/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.JavaSlimFactory;
import fitnesse.slim.SlimFactory;
import fitnesse.slim.SlimServer;
import fitnesse.slim.fixtureInteraction.DefaultInteraction;
import fitnesse.socketservice.SocketFactory;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import util.CommandLine;

public class SlimService {
    public static final String OPTION_DESCRIPTOR = "[-v] [-i interactionClass] [-s statementTimeout] [-d] port";
    static Class<? extends DefaultInteraction> interactionClass = DefaultInteraction.class;
    private final ServerSocket serverSocket;
    private final SlimServer slimServer;
    private final boolean daemon;
    private final Executor executor = Executors.newFixedThreadPool(5);
    static Thread service;

    public static void main(String[] args) throws IOException {
        Options options = SlimService.parseCommandLine(args);
        if (options != null) {
            SlimService.startWithFactory(JavaSlimFactory.createJavaSlimFactory(options), options);
        } else {
            SlimService.parseCommandLineFailed(args);
        }
    }

    protected static void parseCommandLineFailed(String[] args) {
        System.err.println("Invalid command line arguments: " + Arrays.asList(args));
        System.err.println("Usage:");
        System.err.println("    " + SlimService.class.getName() + " " + OPTION_DESCRIPTOR);
    }

    public static void startWithFactory(SlimFactory slimFactory, Options options) throws IOException {
        SlimService slimservice = new SlimService(slimFactory.getSlimServer(options.verbose), options.port, options.interactionClass, options.daemon);
        slimservice.accept();
    }

    public static synchronized void startWithFactoryAsync(SlimFactory slimFactory, Options options) throws IOException {
        if (service != null && service.isAlive()) {
            System.err.println("Already an in-process server running: " + service.getName() + " (alive=" + service.isAlive() + ")");
            service.interrupt();
            throw new RuntimeException("Already an in-process server running: " + service.getName() + " (alive=" + service.isAlive() + ")");
        }
        final SlimService slimservice = new SlimService(slimFactory.getSlimServer(options.verbose), options.port, options.interactionClass, options.daemon);
        service = new Thread(){

            @Override
            public void run() {
                try {
                    slimservice.accept();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        service.start();
    }

    public static void waitForServiceToStopAsync() throws InterruptedException {
        for (int i = 0; i < 1000 && service.isAlive(); ++i) {
            Thread.sleep(50L);
        }
    }

    public static Options parseCommandLine(String[] args) {
        CommandLine commandLine = new CommandLine(OPTION_DESCRIPTOR);
        if (commandLine.parse(args)) {
            boolean verbose = commandLine.hasOption("v");
            String interactionClassName = commandLine.getOptionArgument("i", "interactionClass");
            String portString = commandLine.getArgument("port");
            int port = portString == null ? 8099 : Integer.parseInt(portString);
            String statementTimeoutString = commandLine.getOptionArgument("s", "statementTimeout");
            Integer statementTimeout = statementTimeoutString == null ? null : Integer.valueOf(Integer.parseInt(statementTimeoutString));
            boolean daemon = commandLine.hasOption("d");
            return new Options(verbose, port, SlimService.getInteractionClass(interactionClassName), daemon, statementTimeout);
        }
        return null;
    }

    public SlimService(SlimServer slimServer, int port, Class<? extends DefaultInteraction> interactionClass, boolean daemon) throws IOException {
        SlimService.interactionClass = interactionClass;
        this.daemon = daemon;
        this.slimServer = slimServer;
        try {
            this.serverSocket = SocketFactory.tryCreateServerSocket(port);
        }
        catch (OutOfMemoryError e) {
            System.err.println("Out of Memory. Aborting");
            e.printStackTrace();
            System.exit(99);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept() throws IOException {
        try {
            if (this.daemon) {
                this.acceptMany();
            } else {
                this.acceptOne();
            }
        }
        catch (OutOfMemoryError e) {
            System.err.println("Out of Memory. Aborting");
            e.printStackTrace();
            System.exit(99);
        }
        finally {
            this.serverSocket.close();
        }
    }

    private void acceptMany() throws IOException {
        while (true) {
            final Socket socket = this.serverSocket.accept();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        SlimService.this.handle(socket);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(Socket socket) throws IOException {
        try {
            this.slimServer.serve(socket);
        }
        finally {
            socket.close();
        }
    }

    private void acceptOne() throws IOException {
        Socket socket = this.serverSocket.accept();
        this.handle(socket);
    }

    private static Class<DefaultInteraction> getInteractionClass(String interactionClassName) {
        if (interactionClassName == null) {
            return DefaultInteraction.class;
        }
        try {
            return Class.forName(interactionClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<? extends DefaultInteraction> getInteractionClass() {
        return interactionClass;
    }

    public static class Options {
        final boolean verbose;
        final int port;
        final Class<? extends DefaultInteraction> interactionClass;
        final boolean daemon;
        final Integer statementTimeout;

        public Options(boolean verbose, int port, Class<? extends DefaultInteraction> interactionClass, boolean daemon, Integer statementTimeout) {
            this.verbose = verbose;
            this.port = port;
            this.interactionClass = interactionClass;
            this.daemon = daemon;
            this.statementTimeout = statementTimeout;
        }
    }
}

