/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.slim.SlimError;
import fitnesse.slim.SlimException;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.instructions.InstructionExecutor;
import fitnesse.slim.protocol.SlimDeserializer;
import fitnesse.slim.protocol.SlimSerializer;
import fitnesse.testsystems.CommandRunner;
import fitnesse.testsystems.slim.SlimClient;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import util.ListUtility;
import util.StreamReader;

public class SlimCommandRunningClient
implements SlimClient {
    private static final Logger LOG = Logger.getLogger(SlimCommandRunningClient.class.getName());
    public static final int NO_SLIM_SERVER_CONNECTION_FLAG = -32000;
    public static double MINIMUM_REQUIRED_SLIM_VERSION = 0.3;
    private final CommandRunner slimRunner;
    private final int connectionTimeout;
    private final double requiredSlimVersion;
    private Socket client;
    private StreamReader reader;
    private BufferedWriter writer;
    private String slimServerVersionMessage;
    private double slimServerVersion;
    private String hostName;
    private int port;

    public SlimCommandRunningClient(CommandRunner slimRunner, String hostName, int port, int connectionTimeout, double requiredSlimVersion) {
        this.slimRunner = slimRunner;
        this.hostName = hostName;
        this.port = port;
        this.connectionTimeout = connectionTimeout;
        this.requiredSlimVersion = requiredSlimVersion;
    }

    @Override
    public void start() throws IOException {
        this.slimRunner.asynchronousStart();
        this.connect();
        this.checkForVersionMismatch();
    }

    private void checkForVersionMismatch() {
        double serverVersionNumber = this.getServerVersion();
        if (serverVersionNumber == -32000.0) {
            throw new SlimError("Slim Protocol Version Error: Server did not respond with a valid version number.");
        }
        if (serverVersionNumber < this.requiredSlimVersion) {
            throw new SlimError(String.format("Slim Protocol Version Error: Expected V%s but was V%s", this.requiredSlimVersion, serverVersionNumber));
        }
    }

    @Override
    public void kill() throws IOException {
        if (this.slimRunner != null) {
            this.slimRunner.kill();
        }
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public void connect() throws IOException {
        int maxTries = this.connectionTimeout * 20;
        while (this.client == null) {
            this.client = this.tryConnect(maxTries--);
        }
        this.reader = new StreamReader(this.client.getInputStream());
        this.writer = new BufferedWriter(new OutputStreamWriter(this.client.getOutputStream(), "UTF-8"));
        this.slimServerVersionMessage = this.reader.readLine();
        this.validateConnection();
    }

    private void validateConnection() {
        if (this.isConnected()) {
            this.slimServerVersion = Double.parseDouble(this.slimServerVersionMessage.replace("Slim -- V", ""));
        } else {
            this.slimServerVersion = -32000.0;
            LOG.warning("Error reading Slim Version. Read the following: " + this.slimServerVersionMessage);
        }
    }

    private Socket tryConnect(int maxTries) throws IOException {
        try {
            return new Socket(this.hostName, this.port);
        }
        catch (IOException e) {
            if (maxTries <= 1) {
                throw new SlimError("Error connecting to SLiM server on " + this.hostName + ":" + this.port, e);
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException i) {
                throw new SlimError("Wait for connection interrupted.");
            }
            return null;
        }
    }

    public double getServerVersion() {
        return this.slimServerVersion;
    }

    public boolean isConnected() {
        return this.slimServerVersionMessage.startsWith("Slim -- V");
    }

    @Override
    public Map<String, Object> invokeAndGetResponse(List<Instruction> statements) throws IOException {
        if (statements.size() == 0) {
            return new HashMap<String, Object>();
        }
        String instructions = SlimSerializer.serialize(this.toList(statements));
        this.writeString(instructions);
        int resultLength = this.getLengthToRead();
        String results = this.reader.read(resultLength);
        List<Object> resultList = SlimDeserializer.deserialize(results);
        return SlimCommandRunningClient.resultToMap(resultList);
    }

    private List<Object> toList(List<Instruction> instructions) {
        final ArrayList<Object> statementsAsList = new ArrayList<Object>(instructions.size());
        for (final Instruction instruction : instructions) {
            ToListExecutor executor = new ToListExecutor(){

                @Override
                public void addPath(String path) throws SlimException {
                    statementsAsList.add(ListUtility.list(instruction.getId(), "import", path));
                }

                @Override
                public Object callAndAssign(String symbolName, String instanceName, String methodsName, Object ... arguments) throws SlimException {
                    List<Object> list = ListUtility.list(new Object[]{instruction.getId(), "callAndAssign", symbolName, instanceName, methodsName});
                    SlimCommandRunningClient.addArguments(list, arguments);
                    statementsAsList.add(list);
                    return null;
                }

                @Override
                public Object call(String instanceName, String methodName, Object ... arguments) throws SlimException {
                    List<Object> list = ListUtility.list(new Object[]{instruction.getId(), "call", instanceName, methodName});
                    SlimCommandRunningClient.addArguments(list, arguments);
                    statementsAsList.add(list);
                    return null;
                }

                @Override
                public void create(String instanceName, String className, Object ... constructorArgs) throws SlimException {
                    List<Object> list = ListUtility.list(new Object[]{instruction.getId(), "make", instanceName, className});
                    SlimCommandRunningClient.addArguments(list, constructorArgs);
                    statementsAsList.add(list);
                }
            };
            instruction.execute(executor);
        }
        return statementsAsList;
    }

    private static void addArguments(List<Object> list, Object[] arguments) {
        for (Object arg : arguments) {
            list.add(arg);
        }
    }

    private int getLengthToRead() throws IOException {
        String length = this.reader.read(6);
        try {
            String next;
            Integer resultLength = Integer.parseInt(length);
            while (StringUtils.isNumeric(next = this.reader.read(1))) {
                resultLength = resultLength * 10 + Integer.valueOf(next);
            }
            return resultLength;
        }
        catch (NumberFormatException e) {
            throw new IOException("Stream Read Failure. Can't read length of message from the server.  Possibly test aborted.  Last thing read: " + length);
        }
    }

    protected void writeString(String string) throws IOException {
        String packet = String.format("%06d:%s", string.getBytes("UTF-8").length, string);
        this.writer.write(packet);
        this.writer.flush();
    }

    @Override
    public void bye() throws IOException {
        this.writeString("bye");
        this.slimRunner.join();
        this.kill();
    }

    public static Map<String, Object> resultToMap(List<?> slimResults) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object aResult : slimResults) {
            List resultList = ListUtility.uncheckedCast(Object.class, aResult);
            map.put((String)resultList.get(0), resultList.get(1));
        }
        return map;
    }

    private static interface ToListExecutor
    extends InstructionExecutor {
    }
}

