/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testutil;

import fitnesse.ContextConfigurator;
import fitnesse.FitNesse;
import fitnesse.FitNesseContext;
import fitnesse.PluginException;
import fitnesse.authentication.Authenticator;
import fitnesse.authentication.PromiscuousAuthenticator;
import fitnesse.wiki.RecentChangesWikiPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.fs.ZipFileVersionsController;
import fitnesse.wiki.mem.InMemoryPage;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import util.FileUtil;

public class FitNesseUtil {
    public static final String base = "TestDir";
    public static final int PORT = 1999;
    public static final String URL = "http://localhost:1999/";
    private static FitNesse instance = null;

    public static FitNesseContext startFitnesse(WikiPage root) {
        FitNesseContext context = FitNesseUtil.makeTestContext(root);
        FitNesseUtil.startFitnesseWithContext(context);
        return context;
    }

    public static void startFitnesseWithContext(FitNesseContext context) {
        instance = context.fitNesse;
        instance.start();
    }

    public static void stopFitnesse() throws IOException {
        instance.stop();
        FileUtil.deleteFileSystemDirectory(base);
    }

    public static FitNesseContext makeTestContext() {
        Properties properties = new Properties();
        properties.setProperty("FITNESSE_PORT", String.valueOf(1999));
        return FitNesseUtil.makeTestContext(InMemoryPage.makeRoot("RooT", properties));
    }

    public static FitNesseContext makeTestContext(WikiPage root) {
        return FitNesseUtil.makeTestContext(root, 1999);
    }

    public static FitNesseContext makeTestContext(int port) {
        return FitNesseUtil.makeTestContext(InMemoryPage.makeRoot("root"), port);
    }

    public static FitNesseContext makeTestContext(WikiPage root, int port) {
        return FitNesseUtil.makeTestContext(root, FitNesseUtil.createTemporaryFolder(), base, port, new PromiscuousAuthenticator());
    }

    public static FitNesseContext makeTestContext(WikiPage root, Authenticator authenticator) {
        return FitNesseUtil.makeTestContext(root, FitNesseUtil.createTemporaryFolder(), base, 1999, authenticator);
    }

    public static FitNesseContext makeTestContext(WikiPage root, int port, Authenticator authenticator) {
        return FitNesseUtil.makeTestContext(root, FitNesseUtil.createTemporaryFolder(), base, port, authenticator);
    }

    public static FitNesseContext makeTestContext(WikiPage root, String rootPath, String rootDirectoryName, int port) {
        return FitNesseUtil.makeTestContext(root, rootPath, rootDirectoryName, port, null);
    }

    public static FitNesseContext makeTestContext(WikiPage root, String rootPath, String rootDirectoryName, int port, Authenticator authenticator) {
        FitNesseContext context;
        try {
            context = ContextConfigurator.systemDefaults().withRoot(root).withRootPath(rootPath).withRootDirectoryName(rootDirectoryName).withPort(port).withAuthenticator(authenticator).withVersionsController(new ZipFileVersionsController()).withRecentChanges(new RecentChangesWikiPage()).makeFitNesseContext();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (PluginException e) {
            throw new IllegalStateException(e);
        }
        context.pageFactory.getVelocityEngine();
        return context;
    }

    private static String createTemporaryFolder() {
        File createdFolder;
        try {
            createdFolder = File.createTempFile("fitnesse", "");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create temporary folder for test execution", e);
        }
        createdFolder.delete();
        createdFolder.mkdir();
        return createdFolder.getPath();
    }

    public static void destroyTestContext(FitNesseContext context) {
        FileUtil.deleteFileSystemDirectory(context.rootPath);
    }

    public static void destroyTestContext() {
        FileUtil.deleteFileSystemDirectory(base);
    }
}

