/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MockSocket
extends Socket {
    private static final Logger LOG = Logger.getLogger(MockSocket.class.getName());
    InputStream input;
    OutputStream output;
    private String host;
    private boolean closed;

    public MockSocket() {
        try {
            PipedInputStream serverInput = new PipedInputStream();
            PipedOutputStream clientOutput = new PipedOutputStream(serverInput);
            PipedInputStream clientInput = new PipedInputStream();
            PipedOutputStream serverOutput = new PipedOutputStream(clientInput);
            this.input = serverInput;
            this.output = serverOutput;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MockSocket(String input) {
        this.input = new ByteArrayInputStream(input.getBytes());
        this.output = new ByteArrayOutputStream();
    }

    public MockSocket(InputStream input, OutputStream output) {
        this.input = input;
        this.output = output;
    }

    @Override
    public synchronized InputStream getInputStream() {
        return this.input;
    }

    @Override
    public synchronized OutputStream getOutputStream() {
        return this.output;
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            this.input.close();
            this.output.close();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Unable to close IO", e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public String getOutput() {
        if (this.output instanceof ByteArrayOutputStream) {
            try {
                return ((ByteArrayOutputStream)this.output).toString("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return "";
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return new InetSocketAddress(this.host, 123);
    }
}

