/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageCrawlerImpl;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikitextPage;
import fitnesse.wikitext.parser.HtmlTranslator;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.VariableSource;
import fitnesse.wikitext.parser.WikiSourcePage;
import util.Maybe;

public abstract class BaseWikiPage
implements WikiPage,
WikitextPage {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final WikiPage parent;
    private final VariableSource variableSource;
    private ParsingPage parsingPage;
    private Symbol syntaxTree;

    protected BaseWikiPage(String name, VariableSource variableSource) {
        this(name, null, variableSource);
    }

    protected BaseWikiPage(String name, WikiPage parent) {
        this(name, parent, parent instanceof BaseWikiPage ? ((BaseWikiPage)parent).variableSource : null);
    }

    protected BaseWikiPage(String name, WikiPage parent, VariableSource variableSource) {
        this.name = name;
        this.parent = parent;
        this.variableSource = variableSource;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PageCrawler getPageCrawler() {
        return new PageCrawlerImpl(this);
    }

    @Override
    public WikiPage getParent() {
        return this.parent == null ? this : this.parent;
    }

    @Override
    public boolean isRoot() {
        return this.parent == null || this.parent == this;
    }

    protected VariableSource getVariableSource() {
        return this.variableSource;
    }

    @Override
    public String getVariable(String name) {
        ParsingPage parsingPage = this.getParsingPage();
        Maybe<String> variable = parsingPage.findVariable(name);
        if (variable.isNothing()) {
            return null;
        }
        Parser parser = Parser.make(parsingPage, "", SymbolProvider.variableDefinitionSymbolProvider);
        return new HtmlTranslator(null, parsingPage).translate(parser.parseWithParent(variable.getValue(), null));
    }

    @Override
    public String getHtml() {
        return new HtmlTranslator(this.getParsingPage().getPage(), this.getParsingPage()).translateTree(this.getSyntaxTree());
    }

    @Override
    public ParsingPage getParsingPage() {
        this.parse();
        return this.parsingPage;
    }

    @Override
    public Symbol getSyntaxTree() {
        this.parse();
        return this.syntaxTree;
    }

    private void parse() {
        if (this.syntaxTree == null) {
            this.parsingPage = new ParsingPage(new WikiSourcePage(this), this.getVariableSource());
            this.syntaxTree = Parser.make(this.parsingPage, this.getData().getContent()).parse();
        }
    }

    protected void resetCache() {
        this.parsingPage = null;
        this.syntaxTree = null;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.name;
    }

    @Override
    public int compareTo(Object o) {
        try {
            return this.getPageCrawler().getFullPath().compareTo(((WikiPage)o).getPageCrawler().getFullPath());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WikiPage)) {
            return false;
        }
        try {
            return this.getPageCrawler().getFullPath().equals(((WikiPage)o).getPageCrawler().getFullPath());
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.getPageCrawler().getFullPath().hashCode();
        }
        catch (Exception e) {
            return 0;
        }
    }
}

