/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.mem;

import fitnesse.wiki.fs.FileSystem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import util.Clock;
import util.FileUtil;

public class MemoryFileSystem
implements FileSystem {
    public static final String DIRECTORY_PLACEHOLDER = "*This is a directory*";
    private final Map<String, Payload> files = new LinkedHashMap<String, Payload>();

    @Override
    public void makeFile(File file, String content) {
        this.files.put(file.getPath(), this.payload(content));
    }

    @Override
    public void makeFile(File file, InputStream content) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        FileUtil.copyBytes(content, buf);
        this.makeFile(file, buf.toString("UTF-8"));
    }

    @Override
    public void makeDirectory(File path) {
        this.files.put(path.getPath(), this.payload(DIRECTORY_PLACEHOLDER));
    }

    @Override
    public boolean exists(File file) {
        String path = file.getPath();
        for (String filePath : this.files.keySet()) {
            if (!filePath.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] list(File file) {
        String path = file.getPath();
        ArrayList<String> result = new ArrayList<String>();
        for (String filePath : this.files.keySet()) {
            String newPath;
            if (!filePath.startsWith(path) || filePath.equals(path)) continue;
            String rest = filePath.substring(path.length() + 1);
            int size = rest.indexOf(File.separator);
            if (size < 0) {
                size = rest.length();
            }
            if (result.contains(newPath = rest.substring(0, size))) continue;
            result.add(newPath);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getContent(File file) {
        return this.files.get(file.getPath()).payload;
    }

    @Override
    public InputStream getInputStream(File file) throws IOException {
        return new ByteArrayInputStream(this.files.get(file.getPath()).payload.getBytes("UTF-8"));
    }

    @Override
    public void delete(File fileToDelete) {
        String pathToDelete = fileToDelete.getPath();
        Iterator<String> iter = this.files.keySet().iterator();
        while (iter.hasNext()) {
            String f = iter.next();
            if (!f.startsWith(pathToDelete)) continue;
            iter.remove();
        }
    }

    @Override
    public long lastModified(File file) {
        Payload payload = this.files.get(file.getPath());
        return payload != null ? payload.lastModified : Clock.currentTimeInMillis();
    }

    @Override
    public void rename(File file, File originalFile) {
        throw new RuntimeException("FileSystem.rename() has not been implemented for Memory file system.");
    }

    @Override
    public boolean isDirectory(File file) {
        return DIRECTORY_PLACEHOLDER.equals(this.files.get(file.getPath()).payload);
    }

    private Payload payload(String payload) {
        return new Payload(payload);
    }

    private static class Payload {
        private final String payload;
        private final long lastModified;

        private Payload(String payload) {
            this.payload = payload;
            this.lastModified = new Date().getTime();
        }
    }
}

