/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.refactoring;

import fitnesse.components.TraversalListener;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import java.util.regex.Pattern;

public class ContentReplacingSearchObserver
implements TraversalListener<WikiPage> {
    private Pattern searchPattern;
    private String replacement;

    public ContentReplacingSearchObserver(String searchPattern, String replacement) {
        this.searchPattern = Pattern.compile(searchPattern);
        this.replacement = replacement;
    }

    @Override
    public void process(WikiPage page) {
        PageData pageData = page.getData();
        String replacedContent = this.searchPattern.matcher(pageData.getContent()).replaceAll(this.replacement);
        pageData.setContent(replacedContent);
        page.commit(pageData);
    }
}

