/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.audit;

import com.xebialabs.deployit.audit.CiFormatter;
import com.xebialabs.deployit.engine.spi.event.AuditableDeployitEvent;
import com.xebialabs.deployit.engine.spi.event.CiBaseEvent;
import com.xebialabs.deployit.engine.spi.event.DeployitEventListener;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import nl.javadude.t2bus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DeployitEventListener
public class TextLoggingAuditableEventListener {
    private final CiFormatter formatter = new CiFormatter();

    @Subscribe
    public void log(AuditableDeployitEvent event) {
        Logger logger = LoggerFactory.getLogger((String)("audit." + event.component));
        logger.info("{} - {}", new Object[]{event.username, event.message});
        if (event instanceof CiBaseEvent) {
            CiBaseEvent ciEvent = (CiBaseEvent)event;
            for (ConfigurationItem ci : ciEvent.getCis()) {
                logger.info("{} -     CI [{}]:\n{}", new Object[]{event.username, ci.getId(), this.formatter.format(ci)});
            }
        }
    }
}

