/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.util.concurrent.Monitor;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalFile;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WorkDirFactory {
    public static final String PREVIEW_WORKDIR_PREFIX = "preview";
    @Value(value="#{baseWorkDir}")
    private String baseWorkDirPath;
    private File baseWorkDir;
    private static final Monitor M = new Monitor();
    private static final Logger logger = LoggerFactory.getLogger(WorkDirFactory.class);

    public WorkDirFactory() {
    }

    @PostConstruct
    public void postConstruct() {
        this.baseWorkDir = new File(this.baseWorkDirPath);
        if (!this.baseWorkDir.mkdirs() && !this.baseWorkDir.exists()) {
            throw new RuntimeIOException("Couldn't create the base work directory: " + this.baseWorkDirPath);
        }
        this.cleanUpPreviewDirs();
    }

    public WorkDirFactory(String baseWorkDirPath) {
        this.baseWorkDirPath = baseWorkDirPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkDir newWorkDir(String workdirPrefix) {
        OverthereFile temporaryDirectory = LocalFile.valueOf((File)this.baseWorkDir);
        AtomicInteger integer = new AtomicInteger(1);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS");
        String prefix = (StringUtils.isBlank((String)workdirPrefix) ? "workdir" : workdirPrefix) + "-" + dateFormat.format(new Date());
        String infix = "";
        String suffix = ".tmp";
        while (integer.get() < 100) {
            block6: {
                OverthereFile tempDir = temporaryDirectory.getFile(prefix + infix + suffix);
                M.enter();
                try {
                    if (tempDir.exists()) break block6;
                    try {
                        tempDir.mkdir();
                    }
                    catch (RuntimeIOException ioe) {
                        // empty catch block
                    }
                    logger.debug("Created WorkDir {}", (Object)tempDir);
                    WorkDir workDir = new WorkDir((LocalFile)tempDir);
                    return workDir;
                }
                finally {
                    M.leave();
                }
            }
            infix = "-" + integer.getAndIncrement();
        }
        throw new RuntimeIOException("Cannot create WorkDir " + prefix);
    }

    public WorkDir newWorkDir() {
        return this.newWorkDir(null);
    }

    public void cleanUpPreviewDirs() {
        for (OverthereFile temporaryDirectory : LocalFile.valueOf((File)this.baseWorkDir).listFiles()) {
            if (!temporaryDirectory.getName().startsWith(PREVIEW_WORKDIR_PREFIX) || !temporaryDirectory.isDirectory()) continue;
            try {
                temporaryDirectory.deleteRecursively();
            }
            catch (Exception e) {
                logger.warn("Could not delete preview workdir [{}]; you can do this manually.", (Object)temporaryDirectory.getPath());
            }
        }
    }
}

