/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.stringlib;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.python.core.Py;
import org.python.core.stringlib.InternalFormatSpec;
import org.python.core.util.ExtraMath;

final class InternalFormatter {
    InternalFormatSpec spec;
    boolean negative;
    int precision;

    public InternalFormatter(InternalFormatSpec spec) {
        this.spec = spec;
        this.precision = spec.precision;
        if (this.precision == -1) {
            this.precision = 6;
        }
    }

    private void checkPrecision(String type) {
        if (this.precision > 250) {
            throw Py.OverflowError("formatted " + type + " is too long (precision too long?)");
        }
    }

    private String formatExp(long v, int radix) {
        this.checkPrecision("integer");
        if (v < 0L) {
            this.negative = true;
            v = -v;
        }
        String s = Long.toString(v, radix);
        while (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }

    private static final DecimalFormat getDecimalFormat() {
        return (DecimalFormat)DecimalFormatTemplate.template.clone();
    }

    private static final DecimalFormat getPercentageFormat() {
        return (DecimalFormat)PercentageFormatTemplate.template.clone();
    }

    private String formatFloatDecimal(double v, boolean truncate) {
        this.checkPrecision("decimal");
        if (v < 0.0) {
            v = -v;
            this.negative = true;
        }
        DecimalFormat decimalFormat = InternalFormatter.getDecimalFormat();
        decimalFormat.setMaximumFractionDigits(this.precision);
        decimalFormat.setMinimumFractionDigits(truncate ? 0 : this.precision);
        if (this.spec.thousands_separators) {
            decimalFormat.setGroupingUsed(true);
        }
        String ret = decimalFormat.format(v);
        return ret;
    }

    private String formatPercentage(double v, boolean truncate) {
        this.checkPrecision("decimal");
        if (v < 0.0) {
            v = -v;
            this.negative = true;
        }
        DecimalFormat decimalFormat = InternalFormatter.getPercentageFormat();
        decimalFormat.setMaximumFractionDigits(this.precision);
        decimalFormat.setMinimumFractionDigits(truncate ? 0 : this.precision);
        String ret = decimalFormat.format(v);
        return ret;
    }

    private String formatFloatExponential(double v, char e, boolean truncate) {
        StringBuilder buf = new StringBuilder();
        boolean isNegative = false;
        if (v < 0.0) {
            v = -v;
            isNegative = true;
        }
        double power = 0.0;
        if (v > 0.0) {
            power = ExtraMath.closeFloor(Math.log10(v));
        }
        String exp = this.formatExp((long)power, 10);
        if (this.negative) {
            this.negative = false;
            exp = '-' + exp;
        } else {
            exp = '+' + exp;
        }
        double base = v / Math.pow(10.0, power);
        buf.append(this.formatFloatDecimal(base, truncate));
        buf.append(e);
        buf.append(exp);
        this.negative = isNegative;
        return buf.toString();
    }

    public String format(double value) {
        String string;
        if (this.spec.alternate) {
            throw Py.ValueError("Alternate form (#) not allowed in float format specifier");
        }
        int sign = Double.compare(value, 0.0);
        if (Double.isNaN(value)) {
            string = this.spec.type == 'E' || this.spec.type == 'F' || this.spec.type == 'G' ? "NAN" : "nan";
        } else if (Double.isInfinite(value)) {
            string = this.spec.type == 'E' || this.spec.type == 'F' || this.spec.type == 'G' ? (value > 0.0 ? "INF" : "-INF") : (value > 0.0 ? "inf" : "-inf");
        } else {
            switch (this.spec.type) {
                case 'E': 
                case 'e': {
                    string = this.formatFloatExponential(value, this.spec.type, false);
                    if (this.spec.type != 'E') break;
                    string = string.toUpperCase();
                    break;
                }
                case 'F': 
                case 'f': {
                    string = this.formatFloatDecimal(value, false);
                    if (this.spec.type != 'F') break;
                    string = string.toUpperCase();
                    break;
                }
                case 'G': 
                case 'g': {
                    int exponent = (int)ExtraMath.closeFloor(Math.log10(Math.abs(value == 0.0 ? 1.0 : value)));
                    int origPrecision = this.precision;
                    if (exponent >= -4 && exponent < this.precision) {
                        this.precision -= exponent + 1;
                        string = this.formatFloatDecimal(value, !this.spec.alternate);
                    } else {
                        --this.precision;
                        string = this.formatFloatExponential(value, (char)(this.spec.type - 2), !this.spec.alternate);
                    }
                    if (this.spec.type == 'G') {
                        string = string.toUpperCase();
                    }
                    this.precision = origPrecision;
                    break;
                }
                case '%': {
                    string = this.formatPercentage(value, false);
                    break;
                }
                default: {
                    throw Py.ValueError(String.format("Unknown format code '%c' for object of type 'float'", Character.valueOf(this.spec.type)));
                }
            }
        }
        if (sign >= 0) {
            if (this.spec.sign == '+') {
                string = "+" + string;
            } else if (this.spec.sign == ' ') {
                string = " " + string;
            }
        }
        if (sign < 0 && string.charAt(0) != '-') {
            string = "-" + string;
        }
        return string;
    }

    static class PercentageFormatTemplate {
        static DecimalFormat template = new DecimalFormat("#,##0.#####%", new DecimalFormatSymbols(Locale.US));

        PercentageFormatTemplate() {
        }

        static {
            DecimalFormatSymbols symbols = template.getDecimalFormatSymbols();
            symbols.setNaN("nan");
            symbols.setInfinity("inf");
            template.setDecimalFormatSymbols(symbols);
            template.setGroupingUsed(false);
        }
    }

    static class DecimalFormatTemplate {
        static DecimalFormat template = new DecimalFormat("#,##0.#####", new DecimalFormatSymbols(Locale.US));

        DecimalFormatTemplate() {
        }

        static {
            DecimalFormatSymbols symbols = template.getDecimalFormatSymbols();
            symbols.setNaN("nan");
            symbols.setInfinity("inf");
            template.setDecimalFormatSymbols(symbols);
            template.setGroupingUsed(false);
        }
    }
}

