/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;
import org.python.google.common.annotations.GwtCompatible;
import org.python.google.common.annotations.GwtIncompatible;
import org.python.google.common.collect.ImmutableAsList;
import org.python.google.common.collect.ImmutableCollection;
import org.python.google.common.collect.ImmutableList;
import org.python.google.common.collect.ImmutableMap;
import org.python.google.common.collect.ImmutableSet;
import org.python.google.common.collect.TransformedImmutableSet;

@GwtCompatible(emulated=true)
abstract class ImmutableMapKeySet<K, V>
extends TransformedImmutableSet<Map.Entry<K, V>, K> {
    ImmutableMapKeySet(ImmutableSet<Map.Entry<K, V>> entrySet) {
        super(entrySet);
    }

    ImmutableMapKeySet(ImmutableSet<Map.Entry<K, V>> entrySet, int hashCode) {
        super(entrySet, hashCode);
    }

    abstract ImmutableMap<K, V> map();

    @Override
    K transform(Map.Entry<K, V> entry) {
        return entry.getKey();
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.map().containsKey(object);
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    ImmutableList<K> createAsList() {
        final ImmutableList entryList = ((ImmutableCollection)((Object)this.map().entrySet())).asList();
        return new ImmutableAsList<K>(){

            @Override
            public K get(int index) {
                return ((Map.Entry)entryList.get(index)).getKey();
            }

            @Override
            ImmutableCollection<K> delegateCollection() {
                return ImmutableMapKeySet.this;
            }
        };
    }

    @Override
    @GwtIncompatible(value="serialization")
    Object writeReplace() {
        return new KeySetSerializedForm<K>(this.map());
    }

    @GwtIncompatible(value="serialization")
    private static class KeySetSerializedForm<K>
    implements Serializable {
        final ImmutableMap<K, ?> map;
        private static final long serialVersionUID = 0L;

        KeySetSerializedForm(ImmutableMap<K, ?> map) {
            this.map = map;
        }

        Object readResolve() {
            return this.map.keySet();
        }
    }
}

