/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import java.io.Serializable;

public abstract class CmdLineArgument
implements Serializable {
    public static final String SPECIAL_CHARS_UNIX = " '\"\\;&|()${}*?!<>";
    public static final String SPECIAL_CHARS_WINDOWS = " '\";&|(){}*?";
    private static final String EMPTY_ARGUMENT = "\"\"";

    public static CmdLineArgument arg(String arg) {
        Preconditions.checkNotNull((Object)arg, (Object)"Cannot create a null argument");
        return new Basic(arg);
    }

    public static CmdLineArgument password(String arg) {
        Preconditions.checkNotNull((Object)arg, (Object)"Cannot create a null password argument");
        return new Password(arg);
    }

    public static CmdLineArgument raw(String arg) {
        Preconditions.checkNotNull((Object)arg, (Object)"Cannot create a null raw argument");
        return new Raw(arg);
    }

    public static CmdLineArgument nested(CmdLine line) {
        Preconditions.checkNotNull((Object)line, (Object)"Cannot create a null nested command");
        return new Nested(line);
    }

    public abstract String toString(OperatingSystemFamily var1, boolean var2);

    public abstract void buildString(OperatingSystemFamily var1, boolean var2, StringBuilder var3);

    protected void encodeString(String str, OperatingSystemFamily os, StringBuilder builder) {
        if (str.length() == 0) {
            builder.append(EMPTY_ARGUMENT);
            return;
        }
        switch (os) {
            case WINDOWS: {
                if (!CmdLineArgument.containsAny(str, SPECIAL_CHARS_WINDOWS)) {
                    builder.append(str);
                    break;
                }
                CmdLineArgument.encodeArgumentWithSpecialCharactersForWindows(str, builder);
                break;
            }
            case UNIX: 
            case ZOS: {
                if (!CmdLineArgument.containsAny(str, SPECIAL_CHARS_UNIX)) {
                    builder.append(str);
                    break;
                }
                CmdLineArgument.encodeArgumentWithSpecialCharactersForUnix(str, builder);
                break;
            }
            default: {
                throw new RuntimeException("Unknown os " + (Object)((Object)os));
            }
        }
    }

    private static boolean containsAny(String str, String chars) {
        for (char c : chars.toCharArray()) {
            if (str.indexOf(c) < 0) continue;
            return true;
        }
        return false;
    }

    private static void encodeArgumentWithSpecialCharactersForWindows(String str, StringBuilder builder) {
        builder.append("\"");
        for (int j = 0; j < str.length(); ++j) {
            char c = str.charAt(j);
            if (c == '\"') {
                builder.append(c);
            }
            builder.append(c);
        }
        builder.append("\"");
    }

    private static void encodeArgumentWithSpecialCharactersForUnix(String str, StringBuilder builder) {
        for (int j = 0; j < str.length(); ++j) {
            char c = str.charAt(j);
            if (SPECIAL_CHARS_UNIX.indexOf(c) != -1) {
                builder.append('\\');
            }
            builder.append(c);
        }
    }

    private static class Nested
    extends CmdLineArgument {
        private final CmdLine line;

        public Nested(CmdLine line) {
            this.line = line;
        }

        @Override
        public String toString(OperatingSystemFamily os, boolean forLogging) {
            StringBuilder builder = new StringBuilder();
            this.encodeString(this.line.toCommandLine(os, forLogging), os, builder);
            return builder.toString();
        }

        @Override
        public void buildString(OperatingSystemFamily os, boolean forLogging, StringBuilder builder) {
            this.encodeString(this.line.toCommandLine(os, forLogging), os, builder);
        }

        public String toString() {
            return this.line.toString();
        }
    }

    private static class Password
    extends Basic {
        private static final String HIDDEN_PASSWORD = "********";

        public Password(String arg) {
            super(arg);
        }

        @Override
        public String toString(OperatingSystemFamily os, boolean forLogging) {
            if (forLogging) {
                return HIDDEN_PASSWORD;
            }
            return this.arg;
        }

        @Override
        public void buildString(OperatingSystemFamily os, boolean forLogging, StringBuilder builder) {
            if (forLogging) {
                builder.append(HIDDEN_PASSWORD);
            } else {
                super.buildString(os, forLogging, builder);
            }
        }
    }

    private static class Basic
    extends Single {
        public Basic(String arg) {
            super(arg);
        }

        @Override
        public String toString(OperatingSystemFamily os, boolean forLogging) {
            return this.arg;
        }

        @Override
        public void buildString(OperatingSystemFamily os, boolean forLogging, StringBuilder builder) {
            String s = this.arg;
            this.encodeString(s, os, builder);
        }
    }

    private static class Raw
    extends Single {
        public Raw(String arg) {
            super(arg);
        }

        @Override
        public String toString(OperatingSystemFamily os, boolean forLogging) {
            return this.arg;
        }

        @Override
        public void buildString(OperatingSystemFamily os, boolean forLogging, StringBuilder builder) {
            if (this.arg.length() == 0) {
                builder.append(CmdLineArgument.EMPTY_ARGUMENT);
            } else {
                builder.append(this.arg);
            }
        }
    }

    private static abstract class Single
    extends CmdLineArgument {
        protected String arg;

        private Single(String arg) {
            this.arg = arg;
        }

        public String toString() {
            return this.toString(OperatingSystemFamily.UNIX, true);
        }
    }
}

