/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.telnet;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.cifs.CifsConnection;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.commons.net.telnet.InvalidTelnetOptionException;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.WindowSizeOptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CifsTelnetConnection
extends CifsConnection {
    private static final String DETECTABLE_WINDOWS_PROMPT = "TELNET4OVERTHERE ";
    private static final String ERRORLEVEL_PREAMBLE = "ERRORLEVEL-PREAMBLE";
    private static final String ERRORLEVEL_POSTAMBLE = "ERRORLEVEL-POSTAMBLE";
    private static Logger logger = LoggerFactory.getLogger(CifsTelnetConnection.class);

    public CifsTelnetConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, options, mapper, true);
        Preconditions.checkArgument((this.os == OperatingSystemFamily.WINDOWS ? 1 : 0) != 0, (String)"Cannot create a cifs:%s connection to a host that is not running Windows", (Object[])new Object[]{this.cifsConnectionType.toString().toLowerCase()});
        Preconditions.checkArgument((!this.username.contains("@") ? 1 : 0) != 0, (String)"Cannot create a cifs:%s connection with a new-style Windows domain account [%s], use DOMAIN\\USER instead.", (Object[])new Object[]{this.cifsConnectionType.toString().toLowerCase(), this.username});
    }

    @Override
    public OverthereProcess startProcess(final CmdLine cmd) {
        Preconditions.checkNotNull((Object)cmd, (Object)"Cannot execute null command line");
        Preconditions.checkArgument((cmd.getArguments().size() > 0 ? 1 : 0) != 0, (Object)"Cannot execute empty command line");
        final String obfuscatedCmd = cmd.toCommandLine(this.os, true);
        logger.info("Starting command [{}] on [{}]", (Object)obfuscatedCmd, (Object)this);
        try {
            final TelnetClient tc = new TelnetClient();
            tc.setConnectTimeout(this.connectionTimeoutMillis);
            tc.addOptionHandler((TelnetOptionHandler)new WindowSizeOptionHandler(299, 25, true, false, true, false));
            logger.info("Connecting to telnet://{}@{}", (Object)this.username, (Object)this.address);
            tc.connect(this.address, this.port);
            final InputStream stdout = tc.getInputStream();
            final OutputStream stdin = tc.getOutputStream();
            final PipedInputStream callersStdout = new PipedInputStream();
            final PipedOutputStream toCallersStdout = new PipedOutputStream(callersStdout);
            final ByteArrayOutputStream outputBuf = new ByteArrayOutputStream();
            final int[] exitValue = new int[]{-1};
            final Thread outputReaderThread = new Thread("Telnet output reader"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    try {
                        CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, "ogin:");
                        CifsTelnetConnection.send(stdin, CifsTelnetConnection.this.username);
                        CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, "assword:");
                        CifsTelnetConnection.send(stdin, CifsTelnetConnection.this.password);
                        CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, ">", "ogon failure");
                        CifsTelnetConnection.send(stdin, "PROMPT TELNET4OVERTHERE ");
                        CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, CifsTelnetConnection.DETECTABLE_WINDOWS_PROMPT);
                        CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, CifsTelnetConnection.DETECTABLE_WINDOWS_PROMPT);
                        if (CifsTelnetConnection.this.workingDirectory != null) {
                            CifsTelnetConnection.send(stdin, "CD /D " + CifsTelnetConnection.this.workingDirectory.getPath());
                            CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, CifsTelnetConnection.DETECTABLE_WINDOWS_PROMPT);
                        }
                        CifsTelnetConnection.send(stdin, cmd.toCommandLine(CifsTelnetConnection.this.getHostOperatingSystem(), false));
                        CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, CifsTelnetConnection.DETECTABLE_WINDOWS_PROMPT);
                        CifsTelnetConnection.send(stdin, "ECHO \"ERRORLEVEL-PREAMBLE%errorlevel%ERRORLEVEL-POSTAMBLE");
                        CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, CifsTelnetConnection.ERRORLEVEL_POSTAMBLE);
                        CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, CifsTelnetConnection.ERRORLEVEL_POSTAMBLE);
                        String outputBufStr = outputBuf.toString();
                        int preamblePos = outputBufStr.indexOf(CifsTelnetConnection.ERRORLEVEL_PREAMBLE);
                        int postamblePos = outputBufStr.indexOf(CifsTelnetConnection.ERRORLEVEL_POSTAMBLE);
                        if (preamblePos >= 0 && postamblePos >= 0) {
                            String errorlevelString = outputBufStr.substring(preamblePos + CifsTelnetConnection.ERRORLEVEL_PREAMBLE.length(), postamblePos);
                            logger.debug("Errorlevel string found: {}", (Object)errorlevelString);
                            try {
                                int[] nArray = exitValue;
                                synchronized (exitValue) {
                                    exitValue[0] = Integer.parseInt(errorlevelString);
                                    // ** MonitorExit[var5_6] (shouldn't be in output)
                                    return;
                                }
                            }
                            catch (NumberFormatException exc) {
                                logger.error("Cannot parse errorlevel in Windows output: " + outputBuf);
                            }
                            return;
                        }
                        logger.error("Cannot find errorlevel in Windows output: " + outputBuf);
                        return;
                    }
                    catch (IOException exc) {
                        throw new RuntimeIOException(String.format("Cannot start command [%s] on [%s]", obfuscatedCmd, CifsTelnetConnection.this), exc);
                    }
                    finally {
                        OverthereUtils.closeQuietly(toCallersStdout);
                    }
                }
            };
            outputReaderThread.setDaemon(true);
            outputReaderThread.start();
            return new OverthereProcess(){

                @Override
                public synchronized OutputStream getStdin() {
                    return stdin;
                }

                @Override
                public synchronized InputStream getStdout() {
                    return callersStdout;
                }

                @Override
                public synchronized InputStream getStderr() {
                    return new ByteArrayInputStream(new byte[0]);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public synchronized int waitFor() {
                    if (!tc.isConnected()) {
                        return exitValue[0];
                    }
                    try {
                        try {
                            outputReaderThread.join();
                        }
                        finally {
                            this.disconnect();
                        }
                        return exitValue[0];
                    }
                    catch (InterruptedException exc) {
                        throw new RuntimeIOException(String.format("Cannot start command [%s] on [%s]", obfuscatedCmd, CifsTelnetConnection.this), exc);
                    }
                }

                @Override
                public synchronized void destroy() {
                    if (!tc.isConnected()) {
                        return;
                    }
                    this.disconnect();
                }

                private synchronized void disconnect() {
                    try {
                        tc.disconnect();
                        logger.info("Disconnected from {}", (Object)CifsTelnetConnection.this);
                        OverthereUtils.closeQuietly(toCallersStdout);
                    }
                    catch (IOException exc) {
                        throw new RuntimeIOException(String.format("Cannot disconnect from %s", CifsTelnetConnection.this), exc);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public synchronized int exitValue() {
                    if (tc.isConnected()) {
                        throw new IllegalThreadStateException(String.format("Process for command [%s] on %s is still running", obfuscatedCmd, CifsTelnetConnection.this));
                    }
                    int[] nArray = exitValue;
                    synchronized (exitValue) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return exitValue[0];
                    }
                }
            };
        }
        catch (InvalidTelnetOptionException exc) {
            throw new RuntimeIOException("Cannot execute command " + cmd + " at telnet://" + this.username + "@" + this.address, exc);
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot execute command " + cmd + " at telnet://" + this.username + "@" + this.address, exc);
        }
    }

    private static void receive(InputStream stdout, ByteArrayOutputStream outputBuf, PipedOutputStream toCallersStdout, String expectedString) throws IOException {
        CifsTelnetConnection.receive(stdout, outputBuf, toCallersStdout, expectedString, null);
    }

    private static void receive(InputStream stdout, ByteArrayOutputStream outputBuf, PipedOutputStream toCallersStdout, String expectedString, String unexpectedString) throws IOException {
        String s;
        String outputBufStr;
        boolean lastCharWasCr = false;
        boolean lastCharWasEsc = false;
        do {
            int cInt;
            if ((cInt = stdout.read()) == -1) {
                throw new IOException("End of stream reached");
            }
            outputBuf.write(cInt);
            outputBufStr = outputBuf.toString();
            char c = (char)cInt;
            switch (c) {
                case '\r': {
                    CifsTelnetConnection.handleReceivedLine(outputBuf, outputBufStr, toCallersStdout);
                    break;
                }
                case '\n': {
                    if (lastCharWasCr) break;
                    CifsTelnetConnection.handleReceivedLine(outputBuf, outputBufStr, toCallersStdout);
                    break;
                }
                case '[': {
                    if (!lastCharWasEsc) break;
                    throw new RuntimeIOException("VT100/ANSI escape sequence found in output stream. Please configure the Windows Telnet server to use stream mode (tlntadmn config mode=stream).");
                }
            }
            lastCharWasCr = c == '\r';
            boolean bl = lastCharWasEsc = c == '\u001b';
            if (unexpectedString == null || outputBufStr.length() < unexpectedString.length() || !(s = outputBufStr.substring(outputBufStr.length() - unexpectedString.length(), outputBufStr.length())).equals(unexpectedString)) continue;
            logger.debug("Unexpected string [{}] found in Windows Telnet output", (Object)unexpectedString);
            throw new IOException(String.format("Unexpected string [%s] found in Windows Telnet output", unexpectedString));
        } while (outputBufStr.length() < expectedString.length() || !(s = outputBufStr.substring(outputBufStr.length() - expectedString.length(), outputBufStr.length())).equals(expectedString));
        logger.debug("Expected string [{}] found in Windows Telnet output", (Object)expectedString);
    }

    private static void handleReceivedLine(ByteArrayOutputStream outputBuf, String outputBufStr, PipedOutputStream toCallersStdout) throws IOException {
        if (!outputBufStr.contains(DETECTABLE_WINDOWS_PROMPT)) {
            toCallersStdout.write(outputBuf.toByteArray());
            toCallersStdout.flush();
        }
        outputBuf.reset();
    }

    private static void send(OutputStream stdin, String lineToSend) throws IOException {
        byte[] bytesToSend = (lineToSend + "\r\n").getBytes();
        stdin.write(bytesToSend);
        stdin.flush();
    }
}

