/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.EnumSet;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class CommonStatsFlags
implements Streamable,
Cloneable {
    public static final CommonStatsFlags ALL = new CommonStatsFlags(new Flag[0]).all();
    public static final CommonStatsFlags NONE = new CommonStatsFlags(new Flag[0]).clear();
    private EnumSet<Flag> flags = EnumSet.allOf(Flag.class);
    private String[] types = null;
    private String[] groups = null;
    private String[] fieldDataFields = null;
    private String[] completionDataFields = null;

    public CommonStatsFlags(Flag ... flags) {
        if (flags.length > 0) {
            this.clear();
            for (Flag f : flags) {
                this.flags.add(f);
            }
        }
    }

    public CommonStatsFlags all() {
        this.flags = EnumSet.allOf(Flag.class);
        this.types = null;
        this.groups = null;
        this.fieldDataFields = null;
        this.completionDataFields = null;
        return this;
    }

    public CommonStatsFlags clear() {
        this.flags = EnumSet.noneOf(Flag.class);
        this.types = null;
        this.groups = null;
        this.fieldDataFields = null;
        this.completionDataFields = null;
        return this;
    }

    public boolean anySet() {
        return !this.flags.isEmpty();
    }

    public Flag[] getFlags() {
        return this.flags.toArray(new Flag[this.flags.size()]);
    }

    public CommonStatsFlags types(String ... types) {
        this.types = types;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public CommonStatsFlags groups(String ... groups) {
        this.groups = groups;
        return this;
    }

    public String[] groups() {
        return this.groups;
    }

    public CommonStatsFlags fieldDataFields(String ... fieldDataFields) {
        this.fieldDataFields = fieldDataFields;
        return this;
    }

    public String[] fieldDataFields() {
        return this.fieldDataFields;
    }

    public CommonStatsFlags completionDataFields(String ... completionDataFields) {
        this.completionDataFields = completionDataFields;
        return this;
    }

    public String[] completionDataFields() {
        return this.completionDataFields;
    }

    public boolean isSet(Flag flag) {
        return this.flags.contains((Object)flag);
    }

    boolean unSet(Flag flag) {
        return this.flags.remove((Object)flag);
    }

    void set(Flag flag) {
        this.flags.add(flag);
    }

    public CommonStatsFlags set(Flag flag, boolean add) {
        if (add) {
            this.set(flag);
        } else {
            this.unSet(flag);
        }
        return this;
    }

    public static CommonStatsFlags readCommonStatsFlags(StreamInput in) throws IOException {
        CommonStatsFlags flags = new CommonStatsFlags(new Flag[0]);
        flags.readFrom(in);
        return flags;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        long longFlags = 0L;
        for (Flag flag : this.flags) {
            longFlags |= (long)(1 << flag.ordinal());
        }
        out.writeLong(longFlags);
        out.writeStringArrayNullable(this.types);
        out.writeStringArrayNullable(this.groups);
        out.writeStringArrayNullable(this.fieldDataFields);
        out.writeStringArrayNullable(this.completionDataFields);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        long longFlags = in.readLong();
        this.flags.clear();
        for (Flag flag : Flag.values()) {
            if ((longFlags & (long)(1 << flag.ordinal())) == 0L) continue;
            this.flags.add(flag);
        }
        this.types = in.readStringArray();
        this.groups = in.readStringArray();
        this.fieldDataFields = in.readStringArray();
        this.completionDataFields = in.readStringArray();
    }

    public CommonStatsFlags clone() {
        try {
            CommonStatsFlags cloned = (CommonStatsFlags)super.clone();
            cloned.flags = this.flags.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static enum Flag {
        Store("store"),
        Indexing("indexing"),
        Get("get"),
        Search("search"),
        Merge("merge"),
        Flush("flush"),
        Refresh("refresh"),
        FilterCache("filter_cache"),
        IdCache("id_cache"),
        FieldData("fielddata"),
        Docs("docs"),
        Warmer("warmer"),
        Percolate("percolate"),
        Completion("completion"),
        Segments("segments"),
        Translog("translog"),
        Suggest("suggest");

        private final String restName;

        private Flag(String restName) {
            this.restName = restName;
        }

        public String getRestName() {
            return this.restName;
        }
    }
}

