/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.count;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.count.CountRequest;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.query.QueryBuilder;

public class CountRequestBuilder
extends BroadcastOperationRequestBuilder<CountRequest, CountResponse, CountRequestBuilder, Client> {
    private QuerySourceBuilder sourceBuilder;

    public CountRequestBuilder(Client client) {
        super(client, new CountRequest());
    }

    public CountRequestBuilder setTypes(String ... types) {
        ((CountRequest)this.request).types(types);
        return this;
    }

    public CountRequestBuilder setMinScore(float minScore) {
        ((CountRequest)this.request).minScore(minScore);
        return this;
    }

    public CountRequestBuilder setRouting(String routing) {
        ((CountRequest)this.request).routing(routing);
        return this;
    }

    public CountRequestBuilder setPreference(String preference) {
        ((CountRequest)this.request).preference(preference);
        return this;
    }

    public CountRequestBuilder setRouting(String ... routing) {
        ((CountRequest)this.request).routing(routing);
        return this;
    }

    public CountRequestBuilder setQuery(QueryBuilder queryBuilder) {
        this.sourceBuilder().setQuery(queryBuilder);
        return this;
    }

    public CountRequestBuilder setSource(BytesReference source) {
        ((CountRequest)this.request()).source(source, false);
        return this;
    }

    public CountRequestBuilder setSource(BytesReference source, boolean unsafe) {
        ((CountRequest)this.request()).source(source, unsafe);
        return this;
    }

    public CountRequestBuilder setSource(byte[] querySource) {
        ((CountRequest)this.request).source(querySource);
        return this;
    }

    @Override
    protected void doExecute(ActionListener<CountResponse> listener) {
        if (this.sourceBuilder != null) {
            ((CountRequest)this.request).source(this.sourceBuilder);
        }
        ((Client)this.client).count((CountRequest)this.request, listener);
    }

    private QuerySourceBuilder sourceBuilder() {
        if (this.sourceBuilder == null) {
            this.sourceBuilder = new QuerySourceBuilder();
        }
        return this.sourceBuilder;
    }
}

