/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty;

import java.util.ArrayList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;
import org.elasticsearch.common.netty.buffer.CompositeChannelBuffer;
import org.elasticsearch.common.netty.logging.InternalLogger;
import org.elasticsearch.common.netty.logging.InternalLoggerFactory;
import org.elasticsearch.common.netty.util.ThreadNameDeterminer;
import org.elasticsearch.common.netty.util.ThreadRenamingRunnable;
import org.elasticsearch.transport.netty.NettyInternalESLoggerFactory;

public class NettyUtils {
    private static EsThreadNameDeterminer ES_THREAD_NAME_DETERMINER = new EsThreadNameDeterminer();

    public static void setup() {
    }

    public static ChannelBuffer buildComposite(boolean useGathering, ChannelBuffer ... buffers) {
        if (buffers == null || buffers.length == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        ArrayList<ChannelBuffer> list = Lists.newArrayList();
        for (ChannelBuffer buffer : buffers) {
            if (buffer instanceof CompositeChannelBuffer) {
                CompositeChannelBuffer compBuffer = (CompositeChannelBuffer)buffer;
                list.addAll(compBuffer.decompose(0, compBuffer.readableBytes()));
                continue;
            }
            list.add(buffer);
        }
        return new CompositeChannelBuffer(buffers[0].order(), list, useGathering);
    }

    static {
        InternalLoggerFactory.setDefaultFactory(new NettyInternalESLoggerFactory(){

            @Override
            public InternalLogger newInstance(String name) {
                return super.newInstance(name.replace("org.elasticsearch.common.netty.", "netty.").replace("org.elasticsearch.common.netty.", "netty."));
            }
        });
        ThreadRenamingRunnable.setThreadNameDeterminer(ES_THREAD_NAME_DETERMINER);
    }

    public static class EsThreadNameDeterminer
    implements ThreadNameDeterminer {
        @Override
        public String determineThreadName(String currentThreadName, String proposedThreadName) throws Exception {
            return currentThreadName + "{" + proposedThreadName + "}";
        }
    }
}

