/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class HttpStats
implements Streamable,
ToXContent {
    private long serverOpen;
    private long totalOpen;

    HttpStats() {
    }

    public HttpStats(long serverOpen, long totalOpen) {
        this.serverOpen = serverOpen;
        this.totalOpen = totalOpen;
    }

    public long getServerOpen() {
        return this.serverOpen;
    }

    public long getTotalOpen() {
        return this.totalOpen;
    }

    public static HttpStats readHttpStats(StreamInput in) throws IOException {
        HttpStats stats = new HttpStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.serverOpen = in.readVLong();
        this.totalOpen = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.serverOpen);
        out.writeVLong(this.totalOpen);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.HTTP);
        builder.field(Fields.CURRENT_OPEN, this.serverOpen);
        builder.field(Fields.TOTAL_OPENED, this.totalOpen);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString HTTP = new XContentBuilderString("http");
        static final XContentBuilderString CURRENT_OPEN = new XContentBuilderString("current_open");
        static final XContentBuilderString TOTAL_OPENED = new XContentBuilderString("total_opened");

        Fields() {
        }
    }
}

