/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ar.ArabicStemFilter;
import org.apache.lucene.analysis.bg.BulgarianStemFilter;
import org.apache.lucene.analysis.br.BrazilianStemFilter;
import org.apache.lucene.analysis.ckb.SoraniStemFilter;
import org.apache.lucene.analysis.cz.CzechStemFilter;
import org.apache.lucene.analysis.de.GermanLightStemFilter;
import org.apache.lucene.analysis.de.GermanMinimalStemFilter;
import org.apache.lucene.analysis.el.GreekStemFilter;
import org.apache.lucene.analysis.en.EnglishMinimalStemFilter;
import org.apache.lucene.analysis.en.EnglishPossessiveFilter;
import org.apache.lucene.analysis.en.KStemFilter;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.analysis.es.SpanishLightStemFilter;
import org.apache.lucene.analysis.fi.FinnishLightStemFilter;
import org.apache.lucene.analysis.fr.FrenchLightStemFilter;
import org.apache.lucene.analysis.fr.FrenchMinimalStemFilter;
import org.apache.lucene.analysis.gl.GalicianMinimalStemFilter;
import org.apache.lucene.analysis.gl.GalicianStemFilter;
import org.apache.lucene.analysis.hi.HindiStemFilter;
import org.apache.lucene.analysis.hu.HungarianLightStemFilter;
import org.apache.lucene.analysis.id.IndonesianStemFilter;
import org.apache.lucene.analysis.it.ItalianLightStemFilter;
import org.apache.lucene.analysis.lv.LatvianStemFilter;
import org.apache.lucene.analysis.no.NorwegianLightStemFilter;
import org.apache.lucene.analysis.no.NorwegianMinimalStemFilter;
import org.apache.lucene.analysis.pt.PortugueseLightStemFilter;
import org.apache.lucene.analysis.pt.PortugueseMinimalStemFilter;
import org.apache.lucene.analysis.pt.PortugueseStemFilter;
import org.apache.lucene.analysis.ru.RussianLightStemFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.sv.SwedishLightStemFilter;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettings;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.ArmenianStemmer;
import org.tartarus.snowball.ext.BasqueStemmer;
import org.tartarus.snowball.ext.CatalanStemmer;
import org.tartarus.snowball.ext.DanishStemmer;
import org.tartarus.snowball.ext.DutchStemmer;
import org.tartarus.snowball.ext.EnglishStemmer;
import org.tartarus.snowball.ext.FinnishStemmer;
import org.tartarus.snowball.ext.FrenchStemmer;
import org.tartarus.snowball.ext.German2Stemmer;
import org.tartarus.snowball.ext.GermanStemmer;
import org.tartarus.snowball.ext.HungarianStemmer;
import org.tartarus.snowball.ext.IrishStemmer;
import org.tartarus.snowball.ext.ItalianStemmer;
import org.tartarus.snowball.ext.KpStemmer;
import org.tartarus.snowball.ext.LovinsStemmer;
import org.tartarus.snowball.ext.NorwegianStemmer;
import org.tartarus.snowball.ext.PorterStemmer;
import org.tartarus.snowball.ext.PortugueseStemmer;
import org.tartarus.snowball.ext.RomanianStemmer;
import org.tartarus.snowball.ext.RussianStemmer;
import org.tartarus.snowball.ext.SpanishStemmer;
import org.tartarus.snowball.ext.SwedishStemmer;
import org.tartarus.snowball.ext.TurkishStemmer;

public class StemmerTokenFilterFactory
extends AbstractTokenFilterFactory {
    private String language;

    @Inject
    public StemmerTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        this.language = Strings.capitalize(settings.get("language", settings.get("name", "porter")));
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        Version indexVersion = this.indexSettings.getAsVersion("index.version.created", Version.CURRENT);
        if ("arabic".equalsIgnoreCase(this.language)) {
            return new ArabicStemFilter(tokenStream);
        }
        if ("armenian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new ArmenianStemmer());
        }
        if ("basque".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new BasqueStemmer());
        }
        if ("brazilian".equalsIgnoreCase(this.language)) {
            return new BrazilianStemFilter(tokenStream);
        }
        if ("bulgarian".equalsIgnoreCase(this.language)) {
            return new BulgarianStemFilter(tokenStream);
        }
        if ("catalan".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new CatalanStemmer());
        }
        if ("czech".equalsIgnoreCase(this.language)) {
            return new CzechStemFilter(tokenStream);
        }
        if ("danish".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new DanishStemmer());
        }
        if ("dutch".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new DutchStemmer());
        }
        if ("dutch_kp".equalsIgnoreCase(this.language) || "dutchKp".equalsIgnoreCase(this.language) || "kp".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new KpStemmer());
        }
        if ("english".equalsIgnoreCase(this.language)) {
            if (indexVersion.onOrAfter(Version.V_1_3_0)) {
                return new PorterStemFilter(tokenStream);
            }
            return new SnowballFilter(tokenStream, (SnowballProgram)new EnglishStemmer());
        }
        if ("light_english".equalsIgnoreCase(this.language) || "lightEnglish".equalsIgnoreCase(this.language) || "kstem".equalsIgnoreCase(this.language)) {
            return new KStemFilter(tokenStream);
        }
        if ("lovins".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new LovinsStemmer());
        }
        if ("porter".equalsIgnoreCase(this.language)) {
            return new PorterStemFilter(tokenStream);
        }
        if ("porter2".equalsIgnoreCase(this.language)) {
            if (indexVersion.onOrAfter(Version.V_1_3_0)) {
                return new SnowballFilter(tokenStream, (SnowballProgram)new EnglishStemmer());
            }
            return new SnowballFilter(tokenStream, (SnowballProgram)new PorterStemmer());
        }
        if ("minimal_english".equalsIgnoreCase(this.language) || "minimalEnglish".equalsIgnoreCase(this.language)) {
            return new EnglishMinimalStemFilter(tokenStream);
        }
        if ("possessive_english".equalsIgnoreCase(this.language) || "possessiveEnglish".equalsIgnoreCase(this.language)) {
            return new EnglishPossessiveFilter(this.version, tokenStream);
        }
        if ("finnish".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new FinnishStemmer());
        }
        if ("light_finish".equalsIgnoreCase(this.language) || "lightFinish".equalsIgnoreCase(this.language)) {
            return new FinnishLightStemFilter(tokenStream);
        }
        if ("light_finnish".equalsIgnoreCase(this.language) || "lightFinnish".equalsIgnoreCase(this.language)) {
            return new FinnishLightStemFilter(tokenStream);
        }
        if ("french".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new FrenchStemmer());
        }
        if ("light_french".equalsIgnoreCase(this.language) || "lightFrench".equalsIgnoreCase(this.language)) {
            return new FrenchLightStemFilter(tokenStream);
        }
        if ("minimal_french".equalsIgnoreCase(this.language) || "minimalFrench".equalsIgnoreCase(this.language)) {
            return new FrenchMinimalStemFilter(tokenStream);
        }
        if ("galician".equalsIgnoreCase(this.language)) {
            return new GalicianStemFilter(tokenStream);
        }
        if ("minimal_galician".equalsIgnoreCase(this.language)) {
            return new GalicianMinimalStemFilter(tokenStream);
        }
        if ("german".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new GermanStemmer());
        }
        if ("german2".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new German2Stemmer());
        }
        if ("light_german".equalsIgnoreCase(this.language) || "lightGerman".equalsIgnoreCase(this.language)) {
            return new GermanLightStemFilter(tokenStream);
        }
        if ("minimal_german".equalsIgnoreCase(this.language) || "minimalGerman".equalsIgnoreCase(this.language)) {
            return new GermanMinimalStemFilter(tokenStream);
        }
        if ("greek".equalsIgnoreCase(this.language)) {
            return new GreekStemFilter(tokenStream);
        }
        if ("hindi".equalsIgnoreCase(this.language)) {
            return new HindiStemFilter(tokenStream);
        }
        if ("hungarian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new HungarianStemmer());
        }
        if ("light_hungarian".equalsIgnoreCase(this.language) || "lightHungarian".equalsIgnoreCase(this.language)) {
            return new HungarianLightStemFilter(tokenStream);
        }
        if ("indonesian".equalsIgnoreCase(this.language)) {
            return new IndonesianStemFilter(tokenStream);
        }
        if ("irish".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new IrishStemmer());
        }
        if ("italian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new ItalianStemmer());
        }
        if ("light_italian".equalsIgnoreCase(this.language) || "lightItalian".equalsIgnoreCase(this.language)) {
            return new ItalianLightStemFilter(tokenStream);
        }
        if ("latvian".equalsIgnoreCase(this.language)) {
            return new LatvianStemFilter(tokenStream);
        }
        if ("norwegian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new NorwegianStemmer());
        }
        if ("light_norwegian".equalsIgnoreCase(this.language) || "lightNorwegian".equalsIgnoreCase(this.language)) {
            return new NorwegianLightStemFilter(tokenStream);
        }
        if ("minimal_norwegian".equalsIgnoreCase(this.language) || "minimalNorwegian".equals(this.language)) {
            return new NorwegianMinimalStemFilter(tokenStream);
        }
        if ("light_nynorsk".equalsIgnoreCase(this.language) || "lightNynorsk".equalsIgnoreCase(this.language)) {
            return new NorwegianLightStemFilter(tokenStream, 2);
        }
        if ("minimal_nynorsk".equalsIgnoreCase(this.language) || "minimalNynorsk".equalsIgnoreCase(this.language)) {
            return new NorwegianMinimalStemFilter(tokenStream, 2);
        }
        if ("portuguese".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new PortugueseStemmer());
        }
        if ("light_portuguese".equalsIgnoreCase(this.language) || "lightPortuguese".equalsIgnoreCase(this.language)) {
            return new PortugueseLightStemFilter(tokenStream);
        }
        if ("minimal_portuguese".equalsIgnoreCase(this.language) || "minimalPortuguese".equalsIgnoreCase(this.language)) {
            return new PortugueseMinimalStemFilter(tokenStream);
        }
        if ("portuguese_rslp".equalsIgnoreCase(this.language)) {
            return new PortugueseStemFilter(tokenStream);
        }
        if ("romanian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new RomanianStemmer());
        }
        if ("russian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new RussianStemmer());
        }
        if ("light_russian".equalsIgnoreCase(this.language) || "lightRussian".equalsIgnoreCase(this.language)) {
            return new RussianLightStemFilter(tokenStream);
        }
        if ("spanish".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new SpanishStemmer());
        }
        if ("light_spanish".equalsIgnoreCase(this.language) || "lightSpanish".equalsIgnoreCase(this.language)) {
            return new SpanishLightStemFilter(tokenStream);
        }
        if ("sorani".equalsIgnoreCase(this.language)) {
            return new SoraniStemFilter(tokenStream);
        }
        if ("swedish".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new SwedishStemmer());
        }
        if ("light_swedish".equalsIgnoreCase(this.language) || "lightSwedish".equalsIgnoreCase(this.language)) {
            return new SwedishLightStemFilter(tokenStream);
        }
        if ("turkish".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, (SnowballProgram)new TurkishStemmer());
        }
        return new SnowballFilter(tokenStream, this.language);
    }
}

