/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.uri;

import java.io.IOException;
import java.net.URL;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.url.URLBlobStore;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.snapshots.IndexShardRepository;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryName;
import org.elasticsearch.repositories.RepositorySettings;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.threadpool.ThreadPool;

public class URLRepository
extends BlobStoreRepository {
    public static final String TYPE = "url";
    private final URLBlobStore blobStore;
    private final BlobPath basePath;
    private boolean listDirectories;

    @Inject
    public URLRepository(RepositoryName name, RepositorySettings repositorySettings, ThreadPool threadPool, IndexShardRepository indexShardRepository) throws IOException {
        super(name.getName(), repositorySettings, indexShardRepository);
        String path = repositorySettings.settings().get(TYPE, this.componentSettings.get(TYPE));
        if (path == null) {
            throw new RepositoryException(name.name(), "missing url");
        }
        URL url = new URL(path);
        this.listDirectories = repositorySettings.settings().getAsBoolean("list_directories", this.componentSettings.getAsBoolean("list_directories", (Boolean)true));
        this.blobStore = new URLBlobStore(this.componentSettings, threadPool, url);
        this.basePath = BlobPath.cleanPath();
    }

    @Override
    protected BlobStore blobStore() {
        return this.blobStore;
    }

    @Override
    protected BlobPath basePath() {
        return this.basePath;
    }

    @Override
    public ImmutableList<SnapshotId> snapshots() {
        if (this.listDirectories) {
            return super.snapshots();
        }
        try {
            return this.readSnapshotList();
        }
        catch (IOException ex) {
            throw new RepositoryException(this.repositoryName, "failed to get snapshot list in repository", ex);
        }
    }
}

