/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGridAggregator;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoHashGrid;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParser;
import org.elasticsearch.search.internal.SearchContext;

public class GeoHashGridParser
implements Aggregator.Parser {
    public static final int DEFAULT_PRECISION = 5;
    public static final int DEFAULT_MAX_NUM_CELLS = 10000;

    @Override
    public String type() {
        return InternalGeoHashGrid.TYPE.name();
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        ValuesSourceParser<ValuesSource.GeoPoint> vsParser = ValuesSourceParser.geoPoint(aggregationName, InternalGeoHashGrid.TYPE, context).build();
        int precision = 5;
        int requiredSize = 10000;
        int shardSize = -1;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (vsParser.token(currentFieldName, token, parser) || token != XContentParser.Token.VALUE_NUMBER) continue;
            if ("precision".equals(currentFieldName)) {
                precision = parser.intValue();
                continue;
            }
            if ("size".equals(currentFieldName)) {
                requiredSize = parser.intValue();
                continue;
            }
            if (!"shard_size".equals(currentFieldName) && !"shardSize".equals(currentFieldName)) continue;
            shardSize = parser.intValue();
        }
        if (shardSize == 0) {
            shardSize = Integer.MAX_VALUE;
        }
        if (requiredSize == 0) {
            requiredSize = Integer.MAX_VALUE;
        }
        if (shardSize < 0) {
            shardSize = BucketUtils.suggestShardSideQueueSize(requiredSize, context.numberOfShards());
        }
        if (shardSize < requiredSize) {
            shardSize = requiredSize;
        }
        return new GeoGridFactory(aggregationName, vsParser.config(), precision, requiredSize, shardSize);
    }

    private static class GeoGridFactory
    extends ValuesSourceAggregatorFactory<ValuesSource.GeoPoint> {
        private int precision;
        private int requiredSize;
        private int shardSize;

        public GeoGridFactory(String name, ValuesSourceConfig<ValuesSource.GeoPoint> config, int precision, int requiredSize, int shardSize) {
            super(name, InternalGeoHashGrid.TYPE.name(), config);
            this.precision = precision;
            this.requiredSize = requiredSize;
            this.shardSize = shardSize;
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            final InternalGeoHashGrid aggregation = new InternalGeoHashGrid(this.name, this.requiredSize, Collections.emptyList());
            return new NonCollectingAggregator(this.name, aggregationContext, parent){

                @Override
                public InternalAggregation buildEmptyAggregation() {
                    return aggregation;
                }
            };
        }

        @Override
        protected Aggregator create(ValuesSource.GeoPoint valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            CellValues cellIdValues = new CellValues(valuesSource, this.precision);
            ValuesSource.Numeric cellIdSource = new CellIdSource(cellIdValues, valuesSource.metaData());
            if (((ValuesSource)cellIdSource).metaData().multiValued()) {
                cellIdSource = new ValuesSource.Numeric.SortedAndUnique(cellIdSource);
            }
            return new GeoHashGridAggregator(this.name, this.factories, cellIdSource, this.requiredSize, this.shardSize, aggregationContext, parent);
        }

        private static class CellIdSource
        extends ValuesSource.Numeric {
            private final LongValues values;
            private ValuesSource.MetaData metaData;

            public CellIdSource(LongValues values, ValuesSource.MetaData delegate) {
                this.values = values;
                this.metaData = ValuesSource.MetaData.builder(delegate).uniqueness(ValuesSource.MetaData.Uniqueness.UNKNOWN).build();
            }

            @Override
            public boolean isFloatingPoint() {
                return false;
            }

            @Override
            public LongValues longValues() {
                return this.values;
            }

            @Override
            public DoubleValues doubleValues() {
                throw new UnsupportedOperationException();
            }

            @Override
            public BytesValues bytesValues() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ValuesSource.MetaData metaData() {
                return this.metaData;
            }
        }

        private static class CellValues
        extends LongValues {
            private ValuesSource.GeoPoint geoPointValues;
            private GeoPointValues geoValues;
            private int precision;

            protected CellValues(ValuesSource.GeoPoint geoPointValues, int precision) {
                super(true);
                this.geoPointValues = geoPointValues;
                this.precision = precision;
            }

            @Override
            public int setDocument(int docId) {
                this.geoValues = this.geoPointValues.geoPointValues();
                return this.geoValues.setDocument(docId);
            }

            @Override
            public long nextValue() {
                GeoPoint target = this.geoValues.nextValue();
                return GeoHashUtils.encodeAsLong(target.getLat(), target.getLon(), this.precision);
            }
        }
    }
}

