/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.DoubleTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.GlobalOrdinalsStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.LongTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.ContextIndexSearcher;

public class TermsAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final InternalOrder order;
    private final IncludeExclude includeExclude;
    private final String executionHint;
    private Aggregator.SubAggCollectionMode subAggCollectMode;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;

    public TermsAggregatorFactory(String name, ValuesSourceConfig config, InternalOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, String executionHint, Aggregator.SubAggCollectionMode executionMode) {
        super(name, StringTerms.TYPE.name(), config);
        this.order = order;
        this.includeExclude = includeExclude;
        this.executionHint = executionHint;
        this.bucketCountThresholds = bucketCountThresholds;
        this.subAggCollectMode = executionMode;
    }

    @Override
    protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
        final UnmappedTerms aggregation = new UnmappedTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount());
        return new NonCollectingAggregator(this.name, aggregationContext, parent){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }

    public static long estimatedBucketCount(ValuesSource valuesSource, Aggregator parent) {
        long estimatedBucketCount = valuesSource.metaData().maxAtomicUniqueValuesCount();
        if (estimatedBucketCount < 0L) {
            estimatedBucketCount = 50L;
        }
        estimatedBucketCount = Math.min(estimatedBucketCount, 512L);
        if (Aggregator.hasParentBucketAggregator(parent)) {
            estimatedBucketCount = Math.min(estimatedBucketCount, 8L);
        }
        return estimatedBucketCount;
    }

    protected Aggregator create(ValuesSource valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
        long estimatedBucketCount = TermsAggregatorFactory.estimatedBucketCount(valuesSource, parent);
        if (valuesSource instanceof ValuesSource.Bytes) {
            double ratio;
            long maxOrd;
            ExecutionMode execution = null;
            if (this.executionHint != null) {
                execution = ExecutionMode.fromString(this.executionHint);
            }
            if (!(valuesSource instanceof ValuesSource.Bytes.WithOrdinals)) {
                execution = ExecutionMode.MAP;
            }
            if (execution == null || execution.needsGlobalOrdinals()) {
                ValuesSource.Bytes.WithOrdinals valueSourceWithOrdinals = (ValuesSource.Bytes.WithOrdinals)valuesSource;
                ContextIndexSearcher indexSearcher = aggregationContext.searchContext().searcher();
                maxOrd = valueSourceWithOrdinals.globalMaxOrd(indexSearcher);
                ratio = (double)maxOrd / (double)indexSearcher.getIndexReader().numDocs();
            } else {
                maxOrd = -1L;
                ratio = -1.0;
            }
            if (execution == null) {
                execution = Aggregator.hasParentBucketAggregator(parent) ? ExecutionMode.GLOBAL_ORDINALS_HASH : (this.factories == AggregatorFactories.EMPTY ? (ratio <= 0.5 && maxOrd <= 2048L ? ExecutionMode.GLOBAL_ORDINALS_LOW_CARDINALITY : ExecutionMode.GLOBAL_ORDINALS) : ExecutionMode.GLOBAL_ORDINALS);
            }
            assert (execution != null);
            valuesSource.setNeedsGlobalOrdinals(execution.needsGlobalOrdinals());
            return execution.create(this.name, this.factories, valuesSource, estimatedBucketCount, maxOrd, this.order, this.bucketCountThresholds, this.includeExclude, aggregationContext, parent, this.subAggCollectMode);
        }
        if (this.includeExclude != null) {
            throw new AggregationExecutionException("Aggregation [" + this.name + "] cannot support the include/exclude " + "settings as it can only be applied to string values");
        }
        if (valuesSource instanceof ValuesSource.Numeric) {
            if (((ValuesSource.Numeric)valuesSource).isFloatingPoint()) {
                return new DoubleTermsAggregator(this.name, this.factories, (ValuesSource.Numeric)valuesSource, this.config.format(), estimatedBucketCount, this.order, this.bucketCountThresholds, aggregationContext, parent, this.subAggCollectMode);
            }
            return new LongTermsAggregator(this.name, this.factories, (ValuesSource.Numeric)valuesSource, this.config.format(), estimatedBucketCount, this.order, this.bucketCountThresholds, aggregationContext, parent, this.subAggCollectMode);
        }
        throw new AggregationExecutionException("terms aggregation cannot be applied to field [" + this.config.fieldContext().field() + "]. It can only be applied to numeric or string fields.");
    }

    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, long estimatedBucketCount, long maxOrd, InternalOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode) {
                return new StringTermsAggregator(name, factories, valuesSource, estimatedBucketCount, order, bucketCountThresholds, includeExclude, aggregationContext, parent, subAggCollectMode);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return false;
            }
        }
        ,
        GLOBAL_ORDINALS(new ParseField("global_ordinals", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, long estimatedBucketCount, long maxOrd, InternalOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode) {
                return new GlobalOrdinalsStringTermsAggregator(name, factories, (ValuesSource.Bytes.WithOrdinals.FieldData)valuesSource, estimatedBucketCount, maxOrd, order, bucketCountThresholds, includeExclude, aggregationContext, parent, subAggCollectMode);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return true;
            }
        }
        ,
        GLOBAL_ORDINALS_HASH(new ParseField("global_ordinals_hash", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, long estimatedBucketCount, long maxOrd, InternalOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode) {
                return new GlobalOrdinalsStringTermsAggregator.WithHash(name, factories, (ValuesSource.Bytes.WithOrdinals.FieldData)valuesSource, estimatedBucketCount, maxOrd, order, bucketCountThresholds, includeExclude, aggregationContext, parent, subAggCollectMode);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return true;
            }
        }
        ,
        GLOBAL_ORDINALS_LOW_CARDINALITY(new ParseField("global_ordinals_low_cardinality", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, long estimatedBucketCount, long maxOrd, InternalOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode) {
                if (includeExclude != null || factories != null) {
                    return GLOBAL_ORDINALS.create(name, factories, valuesSource, estimatedBucketCount, maxOrd, order, bucketCountThresholds, includeExclude, aggregationContext, parent, subAggCollectMode);
                }
                return new GlobalOrdinalsStringTermsAggregator.LowCardinality(name, factories, (ValuesSource.Bytes.WithOrdinals.FieldData)valuesSource, estimatedBucketCount, maxOrd, order, bucketCountThresholds, aggregationContext, parent, subAggCollectMode);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return true;
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value) {
            for (ExecutionMode mode : ExecutionMode.values()) {
                if (!mode.parseField.match(value)) continue;
                return mode;
            }
            throw new ElasticsearchIllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of " + ExecutionMode.values());
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, ValuesSource var3, long var4, long var6, InternalOrder var8, TermsAggregator.BucketCountThresholds var9, IncludeExclude var10, AggregationContext var11, Aggregator var12, Aggregator.SubAggCollectionMode var13);

        abstract boolean needsGlobalOrdinals();

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

