/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.tophits;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.tophits.InternalTopHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class TopHitsBuilder
extends AbstractAggregationBuilder {
    private SearchSourceBuilder sourceBuilder;

    public TopHitsBuilder(String name) {
        super(name, InternalTopHits.TYPE.name());
    }

    public TopHitsBuilder setFrom(int from) {
        this.sourceBuilder().from(from);
        return this;
    }

    public TopHitsBuilder setSize(int size) {
        this.sourceBuilder().size(size);
        return this;
    }

    public TopHitsBuilder setTrackScores(boolean trackScores) {
        this.sourceBuilder().trackScores(trackScores);
        return this;
    }

    public TopHitsBuilder setExplain(boolean explain) {
        this.sourceBuilder().explain(explain);
        return this;
    }

    public TopHitsBuilder setVersion(boolean version) {
        this.sourceBuilder().version(version);
        return this;
    }

    public TopHitsBuilder setNoFields() {
        this.sourceBuilder().noFields();
        return this;
    }

    public TopHitsBuilder setFetchSource(boolean fetch) {
        this.sourceBuilder().fetchSource(fetch);
        return this;
    }

    public TopHitsBuilder setFetchSource(@Nullable String include, @Nullable String exclude) {
        this.sourceBuilder().fetchSource(include, exclude);
        return this;
    }

    public TopHitsBuilder setFetchSource(@Nullable String[] includes, @Nullable String[] excludes) {
        this.sourceBuilder().fetchSource(includes, excludes);
        return this;
    }

    public TopHitsBuilder addFieldDataField(String name) {
        this.sourceBuilder().fieldDataField(name);
        return this;
    }

    public TopHitsBuilder addScriptField(String name, String script) {
        this.sourceBuilder().scriptField(name, script);
        return this;
    }

    public TopHitsBuilder addScriptField(String name, String script, Map<String, Object> params) {
        this.sourceBuilder().scriptField(name, script, params);
        return this;
    }

    public TopHitsBuilder addScriptField(String name, String lang, String script, Map<String, Object> params) {
        this.sourceBuilder().scriptField(name, lang, script, params);
        return this;
    }

    public TopHitsBuilder addSort(String field, SortOrder order) {
        this.sourceBuilder().sort(field, order);
        return this;
    }

    public TopHitsBuilder addSort(SortBuilder sort) {
        this.sourceBuilder().sort(sort);
        return this;
    }

    public TopHitsBuilder addHighlightedField(String name) {
        this.highlightBuilder().field(name);
        return this;
    }

    public TopHitsBuilder addHighlightedField(String name, int fragmentSize) {
        this.highlightBuilder().field(name, fragmentSize);
        return this;
    }

    public TopHitsBuilder addHighlightedField(String name, int fragmentSize, int numberOfFragments) {
        this.highlightBuilder().field(name, fragmentSize, numberOfFragments);
        return this;
    }

    public TopHitsBuilder addHighlightedField(String name, int fragmentSize, int numberOfFragments, int fragmentOffset) {
        this.highlightBuilder().field(name, fragmentSize, numberOfFragments, fragmentOffset);
        return this;
    }

    public TopHitsBuilder addHighlightedField(HighlightBuilder.Field field) {
        this.highlightBuilder().field(field);
        return this;
    }

    public TopHitsBuilder setHighlighterTagsSchema(String schemaName) {
        this.highlightBuilder().tagsSchema(schemaName);
        return this;
    }

    public TopHitsBuilder setHighlighterFragmentSize(Integer fragmentSize) {
        this.highlightBuilder().fragmentSize(fragmentSize);
        return this;
    }

    public TopHitsBuilder setHighlighterNumOfFragments(Integer numOfFragments) {
        this.highlightBuilder().numOfFragments(numOfFragments);
        return this;
    }

    public TopHitsBuilder setHighlighterFilter(Boolean highlightFilter) {
        this.highlightBuilder().highlightFilter(highlightFilter);
        return this;
    }

    public TopHitsBuilder setHighlighterEncoder(String encoder) {
        this.highlightBuilder().encoder(encoder);
        return this;
    }

    public TopHitsBuilder setHighlighterPreTags(String ... preTags) {
        this.highlightBuilder().preTags(preTags);
        return this;
    }

    public TopHitsBuilder setHighlighterPostTags(String ... postTags) {
        this.highlightBuilder().postTags(postTags);
        return this;
    }

    public TopHitsBuilder setHighlighterOrder(String order) {
        this.highlightBuilder().order(order);
        return this;
    }

    public TopHitsBuilder setHighlighterRequireFieldMatch(boolean requireFieldMatch) {
        this.highlightBuilder().requireFieldMatch(requireFieldMatch);
        return this;
    }

    public TopHitsBuilder setHighlighterBoundaryMaxScan(Integer boundaryMaxScan) {
        this.highlightBuilder().boundaryMaxScan(boundaryMaxScan);
        return this;
    }

    public TopHitsBuilder setHighlighterBoundaryChars(char[] boundaryChars) {
        this.highlightBuilder().boundaryChars(boundaryChars);
        return this;
    }

    public TopHitsBuilder setHighlighterType(String type) {
        this.highlightBuilder().highlighterType(type);
        return this;
    }

    public TopHitsBuilder setHighlighterFragmenter(String fragmenter) {
        this.highlightBuilder().fragmenter(fragmenter);
        return this;
    }

    public TopHitsBuilder setHighlighterQuery(QueryBuilder highlightQuery) {
        this.highlightBuilder().highlightQuery(highlightQuery);
        return this;
    }

    public TopHitsBuilder setHighlighterNoMatchSize(Integer noMatchSize) {
        this.highlightBuilder().noMatchSize(noMatchSize);
        return this;
    }

    public TopHitsBuilder setHighlighterPhraseLimit(Integer phraseLimit) {
        this.highlightBuilder().phraseLimit(phraseLimit);
        return this;
    }

    public TopHitsBuilder setHighlighterOptions(Map<String, Object> options) {
        this.highlightBuilder().options(options);
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name).field(this.type);
        this.sourceBuilder().toXContent(builder, params);
        return builder.endObject();
    }

    private SearchSourceBuilder sourceBuilder() {
        if (this.sourceBuilder == null) {
            this.sourceBuilder = new SearchSourceBuilder();
        }
        return this.sourceBuilder;
    }

    public HighlightBuilder highlightBuilder() {
        return this.sourceBuilder().highlighter();
    }
}

