/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.transport.TransportAddress;

public abstract class TransportMessage<TM extends TransportMessage<TM>>
implements Streamable {
    private Map<String, Object> headers;
    private TransportAddress remoteAddress;

    protected TransportMessage() {
    }

    protected TransportMessage(TM message) {
        if (((TransportMessage)message).getHeaders() != null) {
            this.headers = new HashMap<String, Object>(((TransportMessage)message).getHeaders());
        }
    }

    public void remoteAddress(TransportAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public TransportAddress remoteAddress() {
        return this.remoteAddress;
    }

    public final TM putHeader(String key, Object value) {
        if (this.headers == null) {
            this.headers = Maps.newHashMap();
        }
        this.headers.put(key, value);
        return (TM)this;
    }

    public final <V> V getHeader(String key) {
        if (this.headers == null) {
            return null;
        }
        return (V)this.headers.get(key);
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.headers = in.readMap();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.headers == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeMap(this.headers);
        }
    }
}

