/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.Modules;
import org.elasticsearch.common.inject.SpawnModules;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.local.LocalTransportModule;
import org.elasticsearch.transport.netty.NettyTransportModule;

public class TransportModule
extends AbstractModule
implements SpawnModules {
    private final Settings settings;
    public static final String TRANSPORT_TYPE_KEY = "transport.type";
    public static final String TRANSPORT_SERVICE_TYPE_KEY = "transport.service.type";

    public TransportModule(Settings settings) {
        this.settings = settings;
    }

    @Override
    public Iterable<? extends Module> spawnModules() {
        Class defaultTransportModule = DiscoveryNode.localNode(this.settings) ? LocalTransportModule.class : NettyTransportModule.class;
        return ImmutableList.of(Modules.createModule(this.settings.getAsClass(TRANSPORT_TYPE_KEY, defaultTransportModule, "org.elasticsearch.transport.", "TransportModule"), this.settings));
    }

    @Override
    protected void configure() {
        Class<TransportService> transportService = this.settings.getAsClass(TRANSPORT_SERVICE_TYPE_KEY, TransportService.class, "org.elasticsearch.transport.", "TransportService");
        if (!TransportService.class.equals(transportService)) {
            this.bind(TransportService.class).to(transportService).asEagerSingleton();
        } else {
            this.bind(TransportService.class).asEagerSingleton();
        }
    }
}

