/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.domain.Qualification;
import com.xebialabs.xltest.domain.TestTool;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(description="A test specification", root=Metadata.ConfigurationItemRoot.CONFIGURATION)
public class TestSpecification
extends BaseTestSpecification {
    private static final Logger LOG = LoggerFactory.getLogger(TestSpecification.class);
    @Property(description="Directory where command is executed")
    private String workingDirectory;
    @Property(description="Name of the test tool, such as JMeter, FitNesse or Cucumber")
    private String testToolName;
    @Property(description="Host where command is executed")
    private Host host;
    @Property(description="Test result file name pattern")
    private String searchPattern;
    @Property(description="The algorithm used to determine the outcome of a test run (success/fail)", required=false)
    private Qualification qualification;

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getTestToolName() {
        return this.testToolName;
    }

    public void setTestToolName(String testToolName) {
        this.testToolName = testToolName;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public String getSearchPattern() {
        return this.searchPattern;
    }

    public void setSearchPattern(String searchPattern) {
        this.searchPattern = searchPattern;
    }

    public OverthereFile getRemotePath() {
        OverthereConnection hostConnection = this.getHost() != null ? this.getHost().getConnection() : LocalConnection.getLocalConnection();
        return hostConnection.getFile(this.workingDirectory);
    }

    public void doImport(UUID testRunId, TestTool testTool, EventHandler eventHandler) {
        this.doImport(testRunId, testTool, this.getRemotePath(), eventHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(UUID testRunId, TestTool testTool, OverthereFile remotePath, EventHandler eventHandler) {
        ImportHandler handler = new ImportHandler(eventHandler);
        try {
            List<Importable> importables = testTool.findImportables(remotePath, new FileMatcher(this.getSearchPattern()));
            LOG.debug("Found {} runs to import", (Object)importables.size());
            for (Importable importable : importables) {
                try {
                    importable.doImport(testRunId, handler);
                }
                catch (Exception e) {
                    LOG.error("Unable to import test run" + importable, (Throwable)e);
                }
            }
        }
        finally {
            remotePath.getConnection().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(TestTool testTool, OverthereFile remotePath, EventHandler eventHandler, ProgressCallback progressCallback) {
        ImportHandler handler = new ImportHandler(eventHandler);
        try {
            int counter = 0;
            List<Importable> importables = testTool.findImportables(remotePath, new FileMatcher(this.getSearchPattern()));
            LOG.debug("Found {} runs to import", (Object)importables.size());
            progressCallback.update(null, ++counter / (importables.size() + 1));
            for (Importable importable : importables) {
                UUID testRunId = UUID.randomUUID();
                try {
                    importable.doImport(testRunId, handler);
                    int percentage = ++counter * 100 / (importables.size() + 1);
                    progressCallback.update(testRunId, percentage);
                }
                catch (Exception e) {
                    LOG.error("Unable to import test run" + importable, (Throwable)e);
                }
            }
        }
        finally {
            remotePath.getConnection().close();
        }
    }

    @Override
    public Qualification getQualification() {
        return this.qualification;
    }

    @Override
    public void setQualification(Qualification qualification) {
        this.qualification = qualification;
    }

    public static interface ProgressCallback {
        public void update(UUID var1, int var2);
    }

    public class ImportHandler
    implements EventHandler {
        private EventHandler eventHandler;
        public int count = 0;

        public ImportHandler(EventHandler eventHandler) {
            this.eventHandler = eventHandler;
        }

        @Override
        public void onReceive(Event event) throws Exception {
            LOG.debug("Importing event {}", (Object)event);
            this.eventHandler.onReceive(new Event(event, Event.props((Object[])new Object[]{"testSpecification", TestSpecification.this.getName()})));
            ++this.count;
        }
    }
}

