/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.checks;

import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;

public class Checks {
    public static void checkArgument(boolean expression, String message, Object ... params) {
        if (!expression) {
            throw new IncorrectArgumentException(message, params);
        }
    }

    public static <T> T checkNotNull(T arg, String name) {
        if (arg == null) {
            throw new MissingArgumentException(name);
        }
        return arg;
    }

    public static <T> T checkNotNull(T arg, String message, Object ... params) {
        if (arg == null) {
            throw new MissingArgumentException(message, params);
        }
        return arg;
    }

    public static void checkTrue(boolean condition, String message, Object ... messageParams) {
        if (!condition) {
            throw new ConditionFailedException(message, messageParams);
        }
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class IncorrectArgumentException
    extends DeployitException {
        public IncorrectArgumentException(String message, Object ... params) {
            super(message, params);
        }
    }

    @HttpResponseCodeResult
    public static class ConditionFailedException
    extends DeployitException {
        public ConditionFailedException(String messageTemplate, Object ... params) {
            super(messageTemplate, params);
        }
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class MissingArgumentException
    extends DeployitException {
        public MissingArgumentException(String parameter) {
            super("Parameter %s is missing", new Object[]{parameter});
        }

        public MissingArgumentException(String messageTemplate, Object ... params) {
            super(messageTemplate, params);
        }
    }
}

