/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.InputSupplier;
import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.AbstractStringView;
import com.xebialabs.deployit.core.ListOfStringView;
import com.xebialabs.deployit.core.MapStringStringView;
import com.xebialabs.deployit.core.SetOfStringView;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.io.Exploder;
import com.xebialabs.deployit.io.Imploder;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.ItemConflictException;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.NodeUtils;
import com.xebialabs.deployit.repository.StringValueConverter;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.util.JavaCryptoUtils;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.overthere.OverthereFile;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.value.ReferenceValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeWriter {
    private final Session session;
    private final ConfigurationItem item;
    private final Node node;
    private final PasswordEncrypter passwordEncrypter;
    private boolean basicsWritten = false;
    private static final Logger logger = LoggerFactory.getLogger(NodeWriter.class);

    NodeWriter(Session session, ConfigurationItem item, Node node, PasswordEncrypter passwordEncrypter) {
        this.session = (Session)Preconditions.checkNotNull((Object)session);
        this.item = (ConfigurationItem)Preconditions.checkNotNull((Object)item);
        this.node = (Node)Preconditions.checkNotNull((Object)node);
        this.passwordEncrypter = (PasswordEncrypter)Preconditions.checkNotNull((Object)passwordEncrypter);
    }

    void writeBasics() throws RepositoryException {
        this.node.setProperty("$configuration.item.type", this.item.getType().toString());
        if (this.item instanceof BaseConfigurationItem) {
            String token = ((BaseConfigurationItem)this.item).get$token();
            if (com.google.common.base.Strings.isNullOrEmpty((String)token) || this.node.hasProperty("$token") && this.node.getProperty("$token").getString().equals(token)) {
                this.node.setProperty("$token", UUID.randomUUID().toString());
            } else {
                throw new ItemConflictException("Repository entity [%s] has been updated since you read it. Please reload the CI from the repository again.", this.item.getId());
            }
        }
        this.basicsWritten = true;
    }

    void write() throws RepositoryException {
        if (!this.basicsWritten) {
            this.writeBasics();
        }
        this.copyData();
        this.copyValuesIntoNode();
        this.copyMetadata();
        this.updateParentForListAsContainmentRelation();
    }

    private void copyData() throws RepositoryException {
        OverthereFile file;
        if (this.item instanceof SourceArtifact && (file = ((Artifact)this.item).getFile()) != null) {
            InputStream dataInput;
            MessageDigest sha1 = JavaCryptoUtils.getSha1();
            this.node.setProperty("$filename", file.getName());
            if (this.item instanceof FolderArtifact) {
                if (file.isDirectory()) {
                    try {
                        InputSupplier<InputStream> implode = Imploder.implode(file, sha1);
                        dataInput = (InputStream)implode.getInput();
                    }
                    catch (IOException e) {
                        throw new RuntimeIOException("Could not zip up the data in file " + file, e);
                    }
                }
                try {
                    Exploder.calculateCheckSum(this.newInputStreamSupplier(file), sha1);
                }
                catch (IOException e) {
                    throw new RuntimeIOException("Could not calculate checksum for zipped Folder artifact.", e);
                }
                dataInput = file.getInputStream();
            } else {
                dataInput = new DigestInputStream(file.getInputStream(), sha1);
            }
            this.writeBinaryData(dataInput);
            if (this.item.hasProperty("checksum") && Strings.isBlank((String)((String)this.item.getProperty("checksum")))) {
                this.item.setProperty("checksum", (Object)JavaCryptoUtils.digest(sha1));
            }
        }
    }

    private InputSupplier<? extends InputStream> newInputStreamSupplier(final OverthereFile file) {
        return new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                return file.getInputStream();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBinaryData(InputStream dataInput) throws RepositoryException {
        try {
            Binary binary = this.session.getValueFactory().createBinary(dataInput);
            this.node.setProperty("$data", binary);
        }
        finally {
            Closeables.closeQuietly((Closeable)dataInput);
        }
    }

    private void copyValuesIntoNode() throws RepositoryException {
        Descriptor ciDescriptor = DescriptorRegistry.getDescriptor((Type)this.item.getType());
        Collection propertyDescriptors = Collections2.filter((Collection)ciDescriptor.getPropertyDescriptors(), (Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return !input.isTransient();
            }
        });
        block10: for (PropertyDescriptor pd : propertyDescriptors) {
            if (pd.get(this.item) == null) {
                this.removePropertyFromNode(pd);
                continue;
            }
            logger.trace("Writing property [{}] with value [{}]", (Object)pd.getFqn(), pd.isPassword() ? "********" : pd.get(this.item));
            switch (pd.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    this.copyPrimitivePropertyIntoNode(pd);
                    continue block10;
                }
                case DATE: {
                    GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                    cal.setTime((Date)pd.get(this.item));
                    this.node.setProperty(pd.getName(), this.session.getValueFactory().createValue((Calendar)cal));
                    continue block10;
                }
                case SET_OF_STRING: {
                    this.copyCollectionOfStringsPropertyIntoNode(pd);
                    continue block10;
                }
                case SET_OF_CI: {
                    this.copyCollectionOfConfigurationItemsPropertyIntoNode(pd);
                    continue block10;
                }
                case LIST_OF_STRING: {
                    this.copyCollectionOfStringsPropertyIntoNode(pd);
                    continue block10;
                }
                case LIST_OF_CI: {
                    this.copyCollectionOfConfigurationItemsPropertyIntoNode(pd);
                    continue block10;
                }
                case CI: {
                    this.copyConfigurationItemPropertyIntoNode(pd);
                    continue block10;
                }
                case MAP_STRING_STRING: {
                    this.copyMapPropertyIntoNode(pd);
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Cannot convert property " + pd.getName() + " because it is of unsupported kind " + pd.getKind());
        }
    }

    private void copyMapPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        MapStringStringView value = MapStringStringView.from((Map)pd.get(this.item));
        Map toWrite = Maps.transformValues(value.getWrapped(), StringValueConverter.valueToString(this.passwordEncrypter));
        JcrUtils.writeMap(this.node, pd.getName(), toWrite);
    }

    private void copyMetadata() throws RepositoryException {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        this.setCreatedByMetadata();
        this.setCreatedAtMetadata(now);
        this.setLastModifiedByMetadata();
        this.setLastModifiedAtMetadata(now);
        if (this.item instanceof BaseConfigurationItem) {
            ((BaseConfigurationItem)this.item).set$ciAttributes(NodeUtils.readCiAttributes(this.node));
        }
    }

    private void setLastModifiedAtMetadata(Calendar now) throws RepositoryException {
        this.node.setProperty("$lastModified", now);
    }

    private void setLastModifiedByMetadata() throws RepositoryException {
        this.node.setProperty("$creatingUser", Permissions.getAuthenticatedUserName());
    }

    private void setCreatedByMetadata() throws RepositoryException {
        if (!this.node.hasProperty("$createdBy")) {
            String username = Permissions.getAuthenticatedUserName();
            if (this.node.hasProperty("$creatingUser")) {
                username = this.node.getProperty("$creatingUser").getString();
            }
            this.node.setProperty("$createdBy", username);
        }
    }

    private void setCreatedAtMetadata(Calendar now) throws RepositoryException {
        if (!this.node.hasProperty("$createdAt")) {
            Calendar when = now;
            if (this.node.hasProperty("$lastModified")) {
                when = this.node.getProperty("$lastModified").getDate();
            }
            this.node.setProperty("$createdAt", when);
        }
    }

    private void removePropertyFromNode(PropertyDescriptor pd) throws RepositoryException {
        try {
            this.node.getProperty(pd.getName()).remove();
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    private void copyPrimitivePropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        String valueAsString = pd.get(this.item).toString();
        if (pd.getKind() == PropertyKind.STRING && pd.isPassword()) {
            valueAsString = this.passwordEncrypter.ensureEncrypted(valueAsString);
        }
        this.node.setProperty(pd.getName(), valueAsString);
    }

    private void copyCollectionOfStringsPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        Property property;
        ValueFactory valueFactory = this.session.getValueFactory();
        StringValueConverter converter = new StringValueConverter(this.passwordEncrypter);
        AbstractStringView valueAsCollection = this.convertObjectValueToCollection(pd, pd.get(this.item));
        ArrayList jcrValueList = Lists.newArrayList();
        if (!(valueAsCollection instanceof AbstractStringView)) {
            valueAsCollection = valueAsCollection instanceof Set ? SetOfStringView.from(valueAsCollection) : ListOfStringView.from((List)((Object)valueAsCollection));
        }
        AbstractStringView view = valueAsCollection;
        for (Object o : view.getWrapped()) {
            if (!(o instanceof StringValue)) {
                throw new IllegalArgumentException("Element in property " + pd.getName() + " of configuration item " + this.item.getId() + " is not a StringValue: " + o);
            }
            StringValue stringValue = (StringValue)o;
            jcrValueList.add(valueFactory.createValue(converter.convert(stringValue)));
        }
        Value[] jcrValues = jcrValueList.toArray(new Value[jcrValueList.size()]);
        if (this.node.hasProperty(pd.getName()) && !(property = this.node.getProperty(pd.getName())).isMultiple()) {
            property.remove();
        }
        this.node.setProperty(pd.getName(), jcrValues);
    }

    private void copyConfigurationItemPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        if (pd.isAsContainment()) {
            return;
        }
        String referencedCiId = ((ConfigurationItem)pd.get(this.item)).getId();
        Node referencedCi = this.session.getNode(JcrPathHelper.getAbsolutePathFromId(referencedCiId));
        this.node.setProperty(pd.getName(), referencedCi);
    }

    private void copyCollectionOfConfigurationItemsPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        if (pd.isAsContainment() && pd.getKind() == PropertyKind.SET_OF_CI) {
            return;
        }
        Collection<?> valueAsCollection = this.convertObjectValueToCollection(pd, pd.get(this.item));
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        ArrayList jcrReferenceList = Lists.newArrayList();
        for (Object each : valueAsCollection) {
            if (!(each instanceof ConfigurationItem)) {
                throw new IllegalArgumentException("Element in property " + pd.getName() + " of repository entity " + this.item.getId() + " is not a ConfigurationItem: " + each);
            }
            String referencedCiId = ((ConfigurationItem)each).getId();
            set.add(referencedCiId);
            Node referencedCi = this.session.getNode(JcrPathHelper.getAbsolutePathFromId(referencedCiId));
            if (pd.isAsContainment() && !referencedCi.getParent().getPath().equals(JcrPathHelper.getAbsolutePathFromId(this.item.getId()))) {
                throw new Checks.IncorrectArgumentException("Cannot add [%s] to property [%s] of item [%s], as it is not contained by it.", referencedCiId, pd.getName(), this.item.getId());
            }
            jcrReferenceList.add(new ReferenceValue(referencedCi));
        }
        if (pd.isAsContainment() && pd.getKind() == PropertyKind.LIST_OF_CI) {
            Map<String, Node> referencesFromProperty = this.getReferencesFromProperty(this.node, pd.getName());
            for (String s : referencesFromProperty.keySet()) {
                if (!set.add(JcrPathHelper.getIdFromAbsolutePath(s))) continue;
                jcrReferenceList.add(new ReferenceValue(referencesFromProperty.get(s)));
            }
        }
        Value[] jcrReferenceValues = jcrReferenceList.toArray(new Value[jcrReferenceList.size()]);
        this.node.setProperty(pd.getName(), jcrReferenceValues);
    }

    private Collection<?> convertObjectValueToCollection(PropertyDescriptor pd, Object value) {
        if (!(value instanceof Collection)) {
            throw new IllegalArgumentException("Property " + pd.getName() + " of repository entity " + this.item.getId() + " is not a Collection: " + value);
        }
        return (Collection)value;
    }

    private void updateParentForListAsContainmentRelation() throws RepositoryException {
        Node parent = this.node.getParent();
        if (parent.getPath().equals(this.session.getRootNode().getPath())) {
            return;
        }
        Type parentType = NodeUtils.typeOf(parent);
        PropertyDescriptor pd = NodeUtils.findContainmentListProperty(parentType, this.item.getType());
        if (pd == null) {
            return;
        }
        String referencingPropertyName = pd.getName();
        Map<String, Node> nodes = this.getReferencesFromProperty(parent, referencingPropertyName);
        nodes.put(this.node.getPath(), this.node);
        ArrayList values = Lists.newArrayList();
        for (Node n : nodes.values()) {
            values.add(new ReferenceValue(n));
        }
        parent.setProperty(referencingPropertyName, values.toArray(new Value[values.size()]));
    }

    private Map<String, Node> getReferencesFromProperty(Node node, String propertyName) throws RepositoryException {
        LinkedHashMap nodes = Maps.newLinkedHashMap();
        if (node.hasProperty(propertyName)) {
            Property referencingProperty = node.getProperty(propertyName);
            for (Value value : referencingProperty.getValues()) {
                Node referencedCiNode = NodeUtils.getReferencedCiNode(node, value, this.session);
                nodes.put(referencedCiNode.getPath(), referencedCiNode);
            }
        }
        return nodes;
    }
}

