/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.io.Exploder;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.overthere.local.LocalFile;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnDemandFileReader
implements JcrCallback<LocalFile>,
Serializable {
    private ConfigurationItem item;
    private String filename;
    private WorkDir workDir;
    private static final Logger logger = LoggerFactory.getLogger(OnDemandFileReader.class);

    public OnDemandFileReader(ConfigurationItem item, String filename, WorkDir workDir) {
        this.item = item;
        this.filename = filename;
        this.workDir = workDir;
    }

    @Override
    public LocalFile doInJcr(Session session) throws RepositoryException {
        return this.getLocalFile(session, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocalFile getLocalFile(Session session, MessageDigest digest) throws RepositoryException {
        LocalFile localFile;
        block6: {
            Descriptor descriptor = this.item.getType().getDescriptor();
            localFile = this.workDir.newFile(this.filename);
            Binary binary = session.getNode(JcrPathHelper.getAbsolutePathFromId(this.item.getId())).getProperty("$data").getBinary();
            try {
                logger.debug("Reading Source Artifact {} of type {} data.", (Object)this.item.getId(), (Object)descriptor);
                if (descriptor.isAssignableTo(FolderArtifact.class)) {
                    localFile.mkdir();
                    try {
                        Exploder.explode(this.binaryToSupplier(binary), localFile.getFile(), digest);
                        break block6;
                    }
                    catch (IOException e) {
                        throw new RuntimeIOException("Could not extract data from " + this.item.getId() + " to directory " + localFile.getPath(), e);
                    }
                }
                this.copyDataToFile(this.item, binary, localFile, digest);
            }
            finally {
                binary.dispose();
            }
        }
        return localFile;
    }

    private InputSupplier<InputStream> binaryToSupplier(final Binary binary) {
        return new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                try {
                    return binary.getStream();
                }
                catch (RepositoryException e) {
                    throw new IOException("Could not get inputstream from node.");
                }
            }
        };
    }

    private <T extends ConfigurationItem> void copyDataToFile(T item, final Binary binaryInput, LocalFile fileOutput, final MessageDigest digest) {
        OutputStream outputStream = fileOutput.getOutputStream();
        try {
            InputSupplier<InputStream> inputSupplier = new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    try {
                        if (digest != null) {
                            return new DigestInputStream(binaryInput.getStream(), digest);
                        }
                        return binaryInput.getStream();
                    }
                    catch (RepositoryException e) {
                        throw new IOException("Could not get inputstream from node.");
                    }
                }
            };
            ByteStreams.copy((InputSupplier)inputSupplier, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Could not copy data from " + item.getId() + " to file " + fileOutput.getPath(), e);
        }
        finally {
            Closeables.closeQuietly((Closeable)outputStream);
        }
    }
}

