/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.xebialabs.deployit.engine.spi.command.CopyCiCommand;
import com.xebialabs.deployit.engine.spi.command.CreateCiCommand;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.DeleteCiCommand;
import com.xebialabs.deployit.engine.spi.command.DeleteCisCommand;
import com.xebialabs.deployit.engine.spi.command.MoveCiCommand;
import com.xebialabs.deployit.engine.spi.command.RenameCiCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCiCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCisCommand;
import com.xebialabs.deployit.engine.spi.command.util.Update;
import com.xebialabs.deployit.engine.spi.event.DeployitEventListener;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.repository.SearchParameters;
import java.util.List;
import nl.javadude.t2bus.Subscribe;

@DeployitEventListener
public class RepositoryEventListener {
    @Subscribe
    public void receiveCreate(CreateCiCommand command) {
        this.checkApplicationOnUniqueness(command.getCi());
        RepositoryServiceHolder.getRepositoryService().create(new ConfigurationItem[]{command.getCi()});
    }

    @Subscribe
    public void receiveCreate(CreateCisCommand command) {
        List listOfCis = command.getCis();
        ConfigurationItem[] cis = listOfCis.toArray(new ConfigurationItem[listOfCis.size()]);
        this.checkApplicationOnUniqueness(cis);
        RepositoryServiceHolder.getRepositoryService().create(cis);
    }

    @Subscribe
    public void receiveUpdate(UpdateCiCommand command) {
        RepositoryServiceHolder.getRepositoryService().update(new ConfigurationItem[]{command.getUpdate().getNewCi()});
    }

    @Subscribe
    public void receiveUpdate(UpdateCisCommand command) {
        List updates = command.getUpdates();
        FluentIterable transform = FluentIterable.from((Iterable)updates).transform((Function)new Function<Update, ConfigurationItem>(){

            public ConfigurationItem apply(Update input) {
                return input.getNewCi();
            }
        });
        ConfigurationItem[] cis = (ConfigurationItem[])transform.toArray(ConfigurationItem.class);
        RepositoryServiceHolder.getRepositoryService().createOrUpdate(cis);
    }

    @Subscribe
    public void receiveDelete(DeleteCiCommand command) {
        RepositoryServiceHolder.getRepositoryService().delete(command.getCiId());
    }

    @Subscribe
    public void receiveDelete(DeleteCisCommand command) {
        RepositoryServiceHolder.getRepositoryService().delete(command.getCis().toArray(new String[command.getCis().size()]));
    }

    @Subscribe
    public void receiveMove(MoveCiCommand command) {
        RepositoryServiceHolder.getRepositoryService().move(command.getId(), command.getTargetId());
    }

    @Subscribe
    public void receiveCopy(CopyCiCommand command) {
        this.checkApplicationOnUniquenessByName(this.getName(command.getTargetId()), command.getType());
        RepositoryServiceHolder.getRepositoryService().copy(command.getId(), command.getTargetId());
    }

    @Subscribe
    public void receiveRename(RenameCiCommand command) {
        this.checkApplicationOnUniquenessByName(command.getTargetName(), command.getType());
        RepositoryServiceHolder.getRepositoryService().rename(command.getId(), command.getTargetName());
    }

    private void checkApplicationOnUniqueness(ConfigurationItem ... cis) {
        for (ConfigurationItem ci : cis) {
            this.checkApplicationOnUniquenessByName(ci.getName(), ci.getType());
        }
    }

    private void checkApplicationOnUniquenessByName(String ciName, Type type) {
        Type applicationType = Type.valueOf(Application.class);
        if (!applicationType.instanceOf(type)) {
            return;
        }
        SearchParameters parameters = new SearchParameters().setType(applicationType).setName(ciName);
        if (!RepositoryServiceHolder.getRepositoryService().list(parameters).isEmpty()) {
            throw new ItemAlreadyExistsException("Application with name [%s] already exists", ciName);
        }
    }

    private String getName(String id) {
        int indexOfLastSlash = id.lastIndexOf(47);
        if (indexOfLastSlash > -1) {
            return id.substring(indexOfLastSlash + 1);
        }
        return id;
    }
}

