/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.service.EventRepository;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRun {
    private static final Logger LOG = LoggerFactory.getLogger(TestRun.class);
    private final UUID testRunId;
    private String testSpecificationName;
    private String uri;
    private Date startTime;
    private Date finishedTime;
    private boolean qualificationResult;
    private String failureReason;
    private Map<String, Object> parameters;
    private EventRepository eventRepository;

    public TestRun(UUID testRunId) {
        this.testRunId = testRunId;
        this.parameters = new HashMap<String, Object>();
    }

    public UUID getTestRunId() {
        return this.testRunId;
    }

    public String getId() {
        return this.testRunId.toString();
    }

    public String getTestSpecificationName() {
        return this.testSpecificationName;
    }

    public void setTestSpecificationName(String testSpecificationName) {
        this.testSpecificationName = testSpecificationName;
    }

    public void setEventRepository(EventRepository eventRepository) {
        this.eventRepository = eventRepository;
    }

    public URI getUri() {
        return UriBuilder.fromUri((String)this.uri).build(new Object[0]);
    }

    public void setUri(URI uri) {
        this.uri = uri.toString();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getFinishedTime() {
        return this.finishedTime;
    }

    public void setFinishedTime(Date finishedTime) {
        this.finishedTime = finishedTime;
    }

    public boolean isFinished() {
        return this.finishedTime != null;
    }

    public boolean getQualificationResult() {
        return this.qualificationResult;
    }

    public void setQualificationResult(boolean qualificationResult) {
        this.qualificationResult = qualificationResult;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public boolean hasParameter(String parameterName) {
        return this.getParameters() != null && this.getParameters().containsKey(parameterName);
    }

    public Object getParameter(String parameterName) {
        return this.getParameters().get(parameterName);
    }

    public List<Event> getEvents(Map queryParameters, String sortingProperty) {
        List<Event> events = this.getEvents(queryParameters);
        return this.sortEvents(events, sortingProperty);
    }

    private List<Event> sortEvents(List<Event> events, final String sortingProperty) {
        ArrayList filteredEvents = Lists.newArrayList((Iterable)Iterables.filter(events, (Predicate)new Predicate<Event>(){

            public boolean apply(Event e) {
                return e.hasProperty(sortingProperty) && e.get(sortingProperty) instanceof Comparable;
            }
        }));
        Collections.sort(filteredEvents, new Comparator<Event>(){

            @Override
            public int compare(Event o1, Event o2) {
                String s1 = (String)o1.get(sortingProperty);
                String s2 = (String)o2.get(sortingProperty);
                return s1.compareTo(s2);
            }
        });
        return filteredEvents;
    }

    public List<Event> getEvents(Map queryParameters) {
        String query = this.constructQuery(this.testRunId, queryParameters);
        return this.eventRepository.query(query);
    }

    private String constructQuery(UUID runId, Map queryParameters) {
        return this.constructSearchQuery("runId:\"" + runId + "\"", queryParameters);
    }

    private String constructSearchQuery(String query, Map queryParameters) {
        for (Object key : queryParameters.keySet()) {
            String value = (String)queryParameters.get(key);
            query = query + " AND " + key + ":\"" + value + "\"";
        }
        return query;
    }

    public List<Event> getEvents() {
        String query = this.constructQuery(this.testRunId, Collections.emptyMap());
        return this.eventRepository.query(query);
    }

    private String getStartDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(this.startTime);
    }

    public List<Event> getEventsWithPrefix(String prefix) {
        LOG.debug("Returning events with prefix {}", (Object)prefix);
        List<Event> events = this.getEvents();
        if (prefix.isEmpty()) {
            return events;
        }
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event ev : events) {
            if (!ev.hasProperty("name") || !ev.get("name").toString().startsWith(prefix)) continue;
            result.add(ev);
        }
        return result;
    }
}

