/*
 * Decompiled with CFR 0.152.
 */
package fit.decorator.util;

import fit.decorator.exceptions.InvalidInputException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

public abstract class DataType {
    private static final String STRING_TYPE = "string";
    private static final String DOUBLE_TYPE = "double";
    private static final String INTEGER_TYPE = "integer";
    private static final String INT_TYPE = "int";
    private static final String DATE_TYPE = "date";
    protected static final DataType INTEGER = new DataType(){

        @Override
        protected Object valueOf(String value) throws Exception {
            return Integer.valueOf(value);
        }

        @Override
        protected String addTo(String originalValue, Object value, int numberofTime) {
            int intValue = (Integer)value * numberofTime;
            return String.valueOf(Integer.parseInt(originalValue) + intValue);
        }

        public String toString() {
            return "DataType = 'int'";
        }
    };
    protected static final DataType DOUBLE = new DataType(){

        @Override
        protected Object valueOf(String value) throws Exception {
            return Double.valueOf(value);
        }

        @Override
        protected String addTo(String originalValue, Object value, int numberofTime) {
            double doubleValue = (Double)value * (double)numberofTime;
            double results = Double.parseDouble(originalValue) + doubleValue;
            return String.valueOf(new Double(results).floatValue());
        }

        public String toString() {
            return "DataType = 'double'";
        }
    };
    protected static final DataType STRING = new DataType(){

        @Override
        protected Object valueOf(String value) throws Exception {
            return value;
        }

        @Override
        protected String addTo(String originalValue, Object value, int numberofTime) {
            return originalValue + this.multiply(value.toString(), numberofTime);
        }

        private String multiply(String value, int numberofTime) {
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < numberofTime; ++i) {
                result.append(value);
            }
            return result.toString();
        }

        public String toString() {
            return "DataType = 'string'";
        }
    };
    protected static final DataType DATE = new DataType(){
        private SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");

        @Override
        protected String addTo(String originalValue, Object value, int numberofTime) {
            GregorianCalendar gc = new GregorianCalendar();
            try {
                Date originalDate = this.dateFormat.parse(originalValue);
                gc.setTime(originalDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            int totalNnumberOfDaysToAdd = (Integer)value * numberofTime;
            gc.add(6, totalNnumberOfDaysToAdd);
            return this.dateFormat.format(gc.getTime());
        }

        @Override
        protected Object valueOf(String value) throws Exception {
            return Integer.valueOf(value);
        }

        public String toString() {
            return "DataType = 'date'";
        }
    };
    private static final Map<String, DataType> predefinedTypes = new HashMap<String, DataType>();
    private static final Map<String, DataType> userDefinedTypes = new HashMap<String, DataType>();

    public Object parse(String value) throws InvalidInputException {
        try {
            return this.valueOf(value);
        }
        catch (Exception e) {
            throw new InvalidInputException("value '" + value + "' is not a valid " + this.toString());
        }
    }

    protected abstract String addTo(String var1, Object var2, int var3);

    protected abstract Object valueOf(String var1) throws Exception;

    static DataType instance(String dataType) throws InvalidInputException {
        Object type = DataType.getDataType(dataType, predefinedTypes);
        if (type == null) {
            type = DataType.getDataType(dataType, userDefinedTypes);
            type = DataType.defaultToStringTypeIfNull(type);
        }
        return (DataType)type;
    }

    private static Object defaultToStringTypeIfNull(Object type) {
        if (type == null) {
            type = STRING;
        }
        return type;
    }

    private static Object getDataType(String dataType, Map<String, DataType> types) {
        return types.get(dataType.toLowerCase());
    }

    public static void registerUserDefinedDataTypes(String key, DataType dataType) {
        userDefinedTypes.put(key.toLowerCase(), dataType);
    }

    public static void clearUserDefinedDataTypes(String key) {
        userDefinedTypes.remove(key.toLowerCase());
    }

    public static void clearUserDefinedDataTypes() {
        userDefinedTypes.clear();
    }

    static {
        predefinedTypes.put(INT_TYPE, INTEGER);
        predefinedTypes.put(INTEGER_TYPE, INTEGER);
        predefinedTypes.put(DOUBLE_TYPE, DOUBLE);
        predefinedTypes.put(STRING_TYPE, STRING);
        predefinedTypes.put(DATE_TYPE, DATE);
    }
}

