/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import fitnesse.util.MockSocket;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.net.Socket;

public class MockResponseSender
implements ResponseSender {
    public MockSocket socket = new MockSocket("Mock");
    protected boolean closed;

    @Override
    public void send(byte[] bytes) {
        try {
            this.socket.getOutputStream().write(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    public String sentData() {
        return this.socket.getOutput();
    }

    public void doSending(Response response) throws IOException {
        response.sendTo(this);
        assert (this.closed);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public static class OutputStreamSender
    extends MockResponseSender {
        public OutputStreamSender(OutputStream out) {
            this.socket = new MockSocket(new PipedInputStream(), out);
        }

        @Override
        public void doSending(Response response) throws IOException {
            response.sendTo(this);
            assert (this.closed);
        }
    }
}

