/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting;

import fitnesse.FitNesseContext;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.reporting.CompositeExecutionLog;
import fitnesse.reporting.InteractiveFormatter;
import fitnesse.testrunner.WikiTestPage;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.io.Closeable;
import java.io.IOException;
import util.TimeMeasurement;

public abstract class SuiteHtmlFormatter
extends InteractiveFormatter
implements Closeable {
    private static final String TEST_SUMMARIES_ID = "test-summaries";
    private TestSummary pageCounts = new TestSummary();
    private int currentTest = 0;
    private final String testBasePathName;
    private String testSystemName = null;
    private int totalTests = 1;
    private TimeMeasurement latestTestTime;
    private String testSummariesId = "test-summaries";
    private TimeMeasurement totalTimeMeasurement = new TimeMeasurement().start();

    public SuiteHtmlFormatter(FitNesseContext context, WikiPage page, CompositeExecutionLog log) {
        super(context, page, log);
        this.testBasePathName = PathParser.render(page.getPageCrawler().getFullPath());
    }

    @Override
    public void announceNumberTestsToRun(int testsToRun) {
        super.announceNumberTestsToRun(testsToRun);
        this.totalTests = testsToRun != 0 ? testsToRun : 1;
    }

    public void announceStartNewTest(String relativeName, String fullPathName) {
        ++this.currentTest;
        this.updateSummaryDiv(this.getProgressHtml(relativeName));
        this.maybeWriteTestSystem();
        this.writeTestOutputDiv(relativeName, fullPathName);
    }

    private void writeTestOutputDiv(String relativeName, String fullPathName) {
        if (!this.testBasePathName.equals(fullPathName)) {
            HtmlTag pageNameBar = HtmlUtil.makeDivTag("test_output_name");
            HtmlTag anchor = HtmlUtil.makeLink(fullPathName, relativeName);
            anchor.addAttribute("id", relativeName + this.currentTest);
            anchor.addAttribute("class", "test_name");
            HtmlTag title = new HtmlTag("h3", anchor);
            HtmlTag topLink = HtmlUtil.makeLink("#test-summaries", "Top");
            topLink.addAttribute("class", "top_of_page");
            pageNameBar.add(title);
            pageNameBar.add(topLink);
            this.writeData(pageNameBar.html());
        }
        this.writeData("<div class=\"alternating_block\">");
    }

    private void maybeWriteTestSystem() {
        if (this.testSystemName != null) {
            HtmlTag systemTitle = new HtmlTag("h2", String.format("Test System: %s", this.testSystemName));
            this.writeData(systemTitle.html());
            this.testSystemName = null;
        }
    }

    @Override
    public void testStarted(WikiTestPage testPage) {
        this.latestTestTime = new TimeMeasurement().start();
        super.testStarted(testPage);
        String fullPathName = testPage.getFullPath();
        this.announceStartNewTest(this.getRelativeName(), fullPathName);
    }

    private String getProgressHtml(String relativeName) {
        float percentFinished = (this.currentTest - 1) * 1000 / this.totalTests;
        percentFinished /= 10.0f;
        String text = "Running tests ... (" + this.currentTest + "/" + this.totalTests + ")";
        text = text.replaceAll(" ", "&nbsp;");
        HtmlTag progressDiv = new HtmlTag("div", text);
        ExecutionResult cssClass = this.currentTest == 1 ? ExecutionResult.PASS : ExecutionResult.getExecutionResult(relativeName, this.pageCounts);
        progressDiv.addAttribute("id", "progressBar");
        progressDiv.addAttribute("class", cssClass.toString());
        progressDiv.addAttribute("style", "width:" + percentFinished + "%");
        return progressDiv.html();
    }

    public void processTestResults(String relativeName, TestSummary testSummary) throws IOException {
        this.finishOutputForTest();
        this.getAssertionCounts().add(testSummary);
        HtmlTag tag = new HtmlTag("li");
        tag.add(HtmlUtil.makeSpanTag("results " + (Object)((Object)ExecutionResult.getExecutionResult(relativeName, testSummary)), testSummary.toString()));
        HtmlTag link = HtmlUtil.makeLink("#" + relativeName + this.currentTest, relativeName);
        link.addAttribute("class", "link");
        tag.add(link);
        if (this.latestTestTime != null) {
            tag.add(HtmlUtil.makeSpanTag("", String.format("(%.03f seconds)", this.latestTestTime.elapsedSeconds())));
        }
        this.pageCounts.tallyPageCounts(ExecutionResult.getExecutionResult(relativeName, testSummary, this.wasInterrupted()));
        HtmlTag insertScript = HtmlUtil.makeAppendElementScript(this.testSummariesId, tag.html());
        this.writeData(insertScript.html());
    }

    private void finishOutputForTest() {
        this.writeData("</div>" + HtmlTag.endl);
    }

    @Override
    public void close() throws IOException {
        this.latestTestTime = this.totalTimeMeasurement.stop();
        this.removeStopTestLink();
        this.AddLogLink();
        this.maybeMakeErrorNavigatorVisible();
        this.finishWritingOutput();
    }

    @Override
    public void testOutputChunk(String output) throws IOException {
        this.writeData(output);
    }

    @Override
    public void testComplete(WikiTestPage testPage, TestSummary testSummary) throws IOException {
        this.latestTestTime.stop();
        super.testComplete(testPage, testSummary);
        this.processTestResults(this.getRelativeName(testPage), testSummary);
        this.latestTestTime = null;
    }

    @Override
    public void errorOccurred(Throwable cause) {
        this.latestTestTime = null;
        super.errorOccurred(cause);
    }

    @Override
    public void testSystemStarted(TestSystem testSystem) {
        this.testSystemName = testSystem.getName();
        this.testSummariesId = "test-system-" + this.testSystemName;
        String tag = String.format("<h3>%s</h3>\n<ul id=\"%s\"></ul>", this.testSystemName, this.testSummariesId);
        HtmlTag insertScript = HtmlUtil.makeAppendElementScript(TEST_SUMMARIES_ID, tag);
        this.writeData(insertScript.html());
    }

    @Override
    protected String makeSummaryContent() {
        String summaryContent = "<strong>Test Pages:</strong> " + this.pageCounts.toString() + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        summaryContent = this.latestTestTime != null ? summaryContent + String.format("<strong>Assertions:</strong> %s (%.03f seconds)", this.getAssertionCounts(), this.latestTestTime.elapsedSeconds()) : summaryContent + String.format("<strong>Assertions:</strong> %s ", this.getAssertionCounts());
        return summaryContent;
    }
}

