/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.WikiImportingResponder;
import fitnesse.responders.editing.EditResponder;
import fitnesse.testrunner.TestPageWithSuiteSetUpAndTearDown;
import fitnesse.testrunner.WikiTestPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageActions;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageUtil;

public class WikiPageResponder
implements SecureResponder {
    @Override
    public Response makeResponse(FitNesseContext context, Request request) {
        WikiPage page = this.loadPage(context, request.getResource());
        if (page == null) {
            return this.notFoundResponse(context, request);
        }
        return this.makePageResponse(context, page);
    }

    protected WikiPage loadPage(FitNesseContext context, String pageName) {
        WikiPage page;
        if ("RecentChanges".equals(pageName)) {
            page = context.recentChanges.toWikiPage(context.root);
        } else {
            WikiPagePath path = PathParser.parse(pageName);
            PageCrawler crawler = context.root.getPageCrawler();
            page = crawler.getPage(path);
        }
        return page;
    }

    private Response notFoundResponse(FitNesseContext context, Request request) {
        if (this.dontCreateNonExistentPage(request)) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        return new EditResponder().makeResponseForNonExistentPage(context, request);
    }

    private boolean dontCreateNonExistentPage(Request request) {
        String dontCreate = (String)request.getInput("dontCreatePage");
        return dontCreate != null && (dontCreate.length() == 0 || Boolean.parseBoolean(dontCreate));
    }

    private SimpleResponse makePageResponse(FitNesseContext context, WikiPage page) {
        String html = this.makeHtml(context, page);
        SimpleResponse response = new SimpleResponse();
        response.setMaxAge(0);
        response.setContent(html);
        return response;
    }

    public String makeHtml(FitNesseContext context, WikiPage page) {
        PageData pageData = page.getData();
        HtmlPage html = context.pageFactory.newPage();
        WikiPagePath fullPath = page.getPageCrawler().getFullPath();
        String fullPathName = PathParser.render(fullPath);
        PageTitle pt = new PageTitle(fullPath);
        String tags = pageData.getAttribute("Suites");
        pt.setPageTags(tags);
        html.setTitle(fullPathName);
        html.setPageTitle(pt.notLinked());
        html.setNavTemplate("wikiNav.vm");
        html.put("actions", new WikiPageActions(page));
        html.put("helpText", pageData.getProperties().get("Help"));
        if (WikiTestPage.isTestPage(page)) {
            TestPageWithSuiteSetUpAndTearDown testPage = new TestPageWithSuiteSetUpAndTearDown(page, context.variableSource);
            html.put("content", new WikiTestPageRenderer(testPage));
        } else {
            html.put("content", new WikiPageRenderer(page));
        }
        html.setMainTemplate("wikiPage");
        html.setFooterTemplate("wikiFooter");
        html.put("footerContent", new WikiPageFooterRenderer(page));
        this.handleSpecialProperties(html, page);
        return html.html();
    }

    private void handleSpecialProperties(HtmlPage html, WikiPage page) {
        WikiImportingResponder.handleImportProperties(html, page);
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }

    public class WikiPageFooterRenderer {
        private WikiPage page;

        WikiPageFooterRenderer(WikiPage page) {
            this.page = page;
        }

        public String render() {
            return WikiPageUtil.getFooterPageHtml(this.page);
        }
    }

    public class WikiTestPageRenderer {
        private WikiTestPage page;

        WikiTestPageRenderer(WikiTestPage page) {
            this.page = page;
        }

        public String render() {
            return WikiPageUtil.makePageHtml(this.page);
        }
    }

    public class WikiPageRenderer {
        private WikiPage page;

        WikiPageRenderer(WikiPage page) {
            this.page = page;
        }

        public String render() {
            return WikiPageUtil.makePageHtml(this.page);
        }
    }
}

