/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner;

import fitnesse.testrunner.CompositeFormatter;
import fitnesse.testrunner.PagesByTestSystem;
import fitnesse.testrunner.Stoppable;
import fitnesse.testrunner.TestingTracker;
import fitnesse.testrunner.WikiPageIdentity;
import fitnesse.testrunner.WikiTestPage;
import fitnesse.testsystems.Assertion;
import fitnesse.testsystems.CompositeExecutionLogListener;
import fitnesse.testsystems.Descriptor;
import fitnesse.testsystems.ExceptionResult;
import fitnesse.testsystems.ExecutionLogListener;
import fitnesse.testsystems.TestResult;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.TestSystemFactory;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.wiki.ClassPathBuilder;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.parser.VariableSource;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultipleTestsRunner
implements Stoppable {
    private static final Logger LOG = Logger.getLogger(MultipleTestsRunner.class.getName());
    private final CompositeFormatter formatters;
    private final PagesByTestSystem pagesByTestSystem;
    private final TestSystemFactory testSystemFactory;
    private final TestingTracker testingTracker;
    private final CompositeExecutionLogListener executionLogListener;
    private final VariableSource variableSource;
    private volatile boolean isStopped = false;
    private String stopId = null;
    private boolean runInProcess;
    private boolean enableRemoteDebug;
    private TestSystem testSystem;
    private volatile int testsInProgressCount;

    public MultipleTestsRunner(PagesByTestSystem pagesByTestSystem, TestingTracker testingTracker, TestSystemFactory testSystemFactory, VariableSource variableSource) {
        this.pagesByTestSystem = pagesByTestSystem;
        this.testingTracker = testingTracker;
        this.testSystemFactory = testSystemFactory;
        this.variableSource = variableSource;
        this.formatters = new CompositeFormatter();
        this.executionLogListener = new CompositeExecutionLogListener();
    }

    public void setRunInProcess(boolean runInProcess) {
        this.runInProcess = runInProcess;
    }

    public void setEnableRemoteDebug(boolean enableRemoteDebug) {
        this.enableRemoteDebug = enableRemoteDebug;
    }

    public void addTestSystemListener(TestSystemListener listener) {
        this.formatters.addTestSystemListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTestPages() throws IOException, InterruptedException {
        try {
            this.internalExecuteTestPages();
        }
        finally {
            this.allTestingComplete();
        }
    }

    private void allTestingComplete() throws IOException {
        this.formatters.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalExecuteTestPages() throws IOException, InterruptedException {
        this.stopId = this.testingTracker.addStartedProcess(this);
        this.formatters.setTrackingId(this.stopId);
        this.announceTotalTestsToRun(this.pagesByTestSystem);
        try {
            for (WikiPageIdentity identity : this.pagesByTestSystem.identities()) {
                this.startTestSystemAndExecutePages(identity, this.pagesByTestSystem.testPagesForIdentity(identity));
            }
        }
        finally {
            this.testingTracker.removeEndedProcess(this.stopId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTestSystemAndExecutePages(WikiPageIdentity identity, List<WikiPage> testSystemPages) throws IOException, InterruptedException {
        TestSystem testSystem = null;
        try {
            if (!this.isStopped) {
                testSystem = this.startTestSystem(identity, testSystemPages);
            }
            if (testSystem != null && testSystem.isSuccessfullyStarted()) {
                this.executeTestSystemPages(testSystemPages, testSystem);
                this.waitForTestSystemToSendResults();
            }
        }
        finally {
            if (!this.isStopped && testSystem != null) {
                testSystem.bye();
            }
        }
    }

    private TestSystem startTestSystem(final WikiPageIdentity identity, final List<WikiPage> testPages) throws IOException {
        Descriptor descriptor = new Descriptor(){
            private String classPath;

            @Override
            public String getTestSystem() {
                String testSystemName = this.getVariable("TEST_SYSTEM");
                if (testSystemName == null) {
                    return "fit";
                }
                return testSystemName;
            }

            @Override
            public String getTestSystemType() {
                return this.getTestSystem().split(":")[0];
            }

            @Override
            public String getClassPath() {
                if (this.classPath == null) {
                    this.classPath = new ClassPathBuilder().buildClassPath(testPages);
                }
                return this.classPath;
            }

            @Override
            public boolean runInProcess() {
                return MultipleTestsRunner.this.runInProcess;
            }

            @Override
            public boolean isDebug() {
                return MultipleTestsRunner.this.enableRemoteDebug;
            }

            @Override
            public String getVariable(String name) {
                return identity.getVariable(name);
            }

            @Override
            public ExecutionLogListener getExecutionLogListener() {
                return MultipleTestsRunner.this.executionLogListener;
            }
        };
        InternalTestSystemListener internalTestSystemListener = new InternalTestSystemListener();
        try {
            this.testSystem = this.testSystemFactory.create(descriptor);
            this.testSystem.addTestSystemListener(internalTestSystemListener);
            this.testSystem.start();
        }
        catch (Exception e) {
            internalTestSystemListener.testOutputChunk(String.format("<span class=\"error\">Unable to start test system '%s': %s</span>", descriptor.getTestSystem(), e.toString()));
            return null;
        }
        return this.testSystem;
    }

    private void executeTestSystemPages(List<WikiPage> pagesInTestSystem, TestSystem testSystem) throws IOException, InterruptedException {
        for (WikiPage testPage : pagesInTestSystem) {
            ++this.testsInProgressCount;
            testSystem.runTests(new WikiTestPage(testPage, this.variableSource));
        }
    }

    private void waitForTestSystemToSendResults() throws InterruptedException {
        while (this.testsInProgressCount > 0 && this.isNotStopped()) {
            Thread.sleep(50L);
        }
    }

    void announceTotalTestsToRun(PagesByTestSystem pagesByTestSystem) {
        this.formatters.announceNumberTestsToRun(pagesByTestSystem.totalTestsToRun());
    }

    public void addExecutionLogListener(ExecutionLogListener listener) {
        this.executionLogListener.addExecutionLogListener(listener);
    }

    private boolean isNotStopped() {
        return !this.isStopped;
    }

    @Override
    public void stop() {
        boolean wasNotStopped = this.isNotStopped();
        this.isStopped = true;
        if (this.stopId != null) {
            this.testingTracker.removeEndedProcess(this.stopId);
        }
        if (wasNotStopped && this.testSystem != null) {
            try {
                this.testSystem.kill();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unable to stop test systems", e);
            }
        }
    }

    private class InternalTestSystemListener
    implements TestSystemListener<WikiTestPage> {
        private InternalTestSystemListener() {
        }

        @Override
        public void testSystemStarted(TestSystem testSystem) {
            MultipleTestsRunner.this.formatters.testSystemStarted(testSystem);
        }

        @Override
        public void testOutputChunk(String output) throws IOException {
            MultipleTestsRunner.this.formatters.testOutputChunk(output);
        }

        @Override
        public void testStarted(WikiTestPage testPage) throws IOException {
            MultipleTestsRunner.this.formatters.testStarted(testPage);
        }

        @Override
        public void testComplete(WikiTestPage testPage, TestSummary testSummary) throws IOException {
            MultipleTestsRunner.this.formatters.testComplete(testPage, testSummary);
            MultipleTestsRunner.this.testsInProgressCount--;
        }

        @Override
        public void testSystemStopped(TestSystem testSystem, Throwable cause) {
            MultipleTestsRunner.this.formatters.testSystemStopped(testSystem, cause);
            if (cause != null) {
                MultipleTestsRunner.this.executionLogListener.exceptionOccurred(cause);
                MultipleTestsRunner.this.stop();
            }
        }

        @Override
        public void testAssertionVerified(Assertion assertion, TestResult testResult) {
            MultipleTestsRunner.this.formatters.testAssertionVerified(assertion, testResult);
        }

        @Override
        public void testExceptionOccurred(Assertion assertion, ExceptionResult exceptionResult) {
            MultipleTestsRunner.this.formatters.testExceptionOccurred(assertion, exceptionResult);
        }
    }
}

