/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner;

import fitnesse.testsystems.CompositeExecutionLogListener;
import fitnesse.testsystems.Descriptor;
import fitnesse.testsystems.ExecutionLogListener;
import fitnesse.wiki.WikiPage;

public class WikiPageDescriptor
implements Descriptor {
    private final WikiPage page;
    private final boolean inProcess;
    private final boolean remoteDebug;
    private final String classPath;

    public WikiPageDescriptor(WikiPage data, boolean inProcess, boolean remoteDebug, String classPath) {
        this.page = data;
        this.inProcess = inProcess;
        this.remoteDebug = remoteDebug;
        this.classPath = classPath;
    }

    @Override
    public String getTestSystem() {
        String testSystemName = this.getVariable("TEST_SYSTEM");
        if (testSystemName == null) {
            return "fit";
        }
        return testSystemName;
    }

    @Override
    public String getTestSystemType() {
        return this.getTestSystem().split(":")[0];
    }

    @Override
    public String getClassPath() {
        return this.classPath;
    }

    @Override
    public boolean runInProcess() {
        return this.inProcess;
    }

    @Override
    public boolean isDebug() {
        return this.remoteDebug;
    }

    @Override
    public String getVariable(String name) {
        return this.page.getVariable(name);
    }

    @Override
    public ExecutionLogListener getExecutionLogListener() {
        return new CompositeExecutionLogListener();
    }
}

