/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.socketservice.SocketFactory;
import fitnesse.testsystems.ClientBuilder;
import fitnesse.testsystems.CommandRunner;
import fitnesse.testsystems.Descriptor;
import fitnesse.testsystems.MockCommandRunner;
import fitnesse.testsystems.slim.SlimCommandRunningClient;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.concurrent.atomic.AtomicInteger;
import util.StringUtil;

public class SlimClientBuilder
extends ClientBuilder<SlimCommandRunningClient> {
    public static final String SLIM_PORT = "SLIM_PORT";
    public static final String SLIM_HOST = "SLIM_HOST";
    public static final String SLIM_FLAGS = "SLIM_FLAGS";
    private static final String SLIM_VERSION = "SLIM_VERSION";
    public static final String MANUALLY_START_TEST_RUNNER_ON_DEBUG = "MANUALLY_START_TEST_RUNNER_ON_DEBUG";
    private static final AtomicInteger slimPortOffset = new AtomicInteger(0);
    private final int slimPort = this.getNextSlimPort();

    public SlimClientBuilder(Descriptor descriptor) {
        super(descriptor);
    }

    @Override
    public SlimCommandRunningClient build() throws IOException {
        CommandRunner commandRunner = this.useManualStartForTestSystem() ? new MockCommandRunner(this.getExecutionLogListener()) : new CommandRunner(this.buildCommand(), "", this.createClasspathEnvironment(this.getClassPath()), this.getExecutionLogListener(), this.determineTimeout());
        return new SlimCommandRunningClient(commandRunner, this.determineSlimHost(), this.getSlimPort(), this.determineTimeout(), this.getSlimVersion());
    }

    public double getSlimVersion() {
        double version = SlimCommandRunningClient.MINIMUM_REQUIRED_SLIM_VERSION;
        try {
            String slimVersion = this.getVariable(SLIM_VERSION);
            if (slimVersion != null) {
                version = Double.valueOf(slimVersion);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return version;
    }

    @Override
    protected String defaultTestRunner() {
        return "fitnesse.slim.SlimService";
    }

    protected String[] buildCommand() {
        String[] slimArguments = this.buildArguments();
        String[] slimCommandPrefix = super.buildCommand(this.getCommandPattern(), this.getTestRunner(), this.getClassPath());
        return StringUtil.combineArrays(slimCommandPrefix, slimArguments);
    }

    protected String[] buildArguments() {
        int slimSocket = this.getSlimPort();
        String slimFlags = this.getSlimFlags();
        if ("".equals(slimFlags)) {
            return new String[]{Integer.toString(slimSocket)};
        }
        return new String[]{slimFlags, Integer.toString(slimSocket)};
    }

    public int getSlimPort() {
        return this.slimPort;
    }

    private int findFreePort() {
        int port;
        try {
            ServerSocket socket = SocketFactory.tryCreateServerSocket(0);
            port = socket.getLocalPort();
            socket.close();
        }
        catch (Exception e) {
            port = -1;
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextSlimPort() {
        int base = this.getSlimPortBase();
        int poolSize = this.getSlimPortPoolSize();
        if (base == 0) {
            return this.findFreePort();
        }
        Class<SlimClientBuilder> clazz = SlimClientBuilder.class;
        synchronized (SlimClientBuilder.class) {
            int offset = slimPortOffset.get();
            offset = (offset + 1) % poolSize;
            slimPortOffset.set(offset);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return offset + base;
        }
    }

    public static void clearSlimPortOffset() {
        slimPortOffset.set(0);
    }

    private int getSlimPortBase() {
        try {
            String port = this.getVariable("slim.port");
            if (port == null) {
                port = this.getVariable(SLIM_PORT);
            }
            if (port != null) {
                return Integer.parseInt(port);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 8085;
    }

    private int getSlimPortPoolSize() {
        try {
            String poolSize = this.getVariable("slim.pool.size");
            if (poolSize != null) {
                return Integer.parseInt(poolSize);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 10;
    }

    protected String determineSlimHost() {
        String slimHost = this.getVariable("slim.host");
        if (slimHost == null) {
            slimHost = this.getVariable(SLIM_HOST);
        }
        return slimHost == null ? "localhost" : slimHost;
    }

    protected String getSlimFlags() {
        String slimFlags = this.getVariable("slim.flags");
        if (slimFlags == null) {
            slimFlags = this.getVariable(SLIM_FLAGS);
        }
        return slimFlags == null ? "" : slimFlags;
    }

    protected int determineTimeout() {
        if (this.isDebug()) {
            try {
                String debugTimeout = this.getVariable("slim.debug.timeout");
                if (debugTimeout != null) {
                    return Integer.parseInt(debugTimeout);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        try {
            String timeout = this.getVariable("slim.timeout");
            if (timeout != null) {
                return Integer.parseInt(timeout);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 10;
    }

    private boolean useManualStartForTestSystem() {
        if (this.isDebug()) {
            String useManualStart = this.getVariable("manually.start.test.runner.on.debug");
            if (useManualStart == null) {
                useManualStart = this.getVariable(MANUALLY_START_TEST_RUNNER_ON_DEBUG);
            }
            return useManualStart != null && useManualStart.toLowerCase().equals("true");
        }
        return false;
    }
}

