/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.testsystems.Assertion;
import fitnesse.testsystems.Instruction;
import fitnesse.testsystems.slim.tables.SlimExpectation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SlimAssertion
implements Assertion {
    private final fitnesse.slim.instructions.Instruction instruction;
    private final SlimExpectation expectation;

    SlimAssertion(fitnesse.slim.instructions.Instruction instruction, SlimExpectation expectation) {
        this.instruction = instruction;
        this.expectation = expectation;
    }

    @Override
    public Instruction getInstruction() {
        return new Instruction(){

            @Override
            public String getId() {
                return SlimAssertion.this.instruction.getId();
            }

            public String toString() {
                return SlimAssertion.this.instruction.toString();
            }
        };
    }

    @Override
    public SlimExpectation getExpectation() {
        return this.expectation;
    }

    public static List<fitnesse.slim.instructions.Instruction> getInstructions(List<SlimAssertion> assertions) {
        ArrayList<fitnesse.slim.instructions.Instruction> instructions = new ArrayList<fitnesse.slim.instructions.Instruction>(assertions.size());
        for (SlimAssertion a : assertions) {
            if (a.instruction == fitnesse.slim.instructions.Instruction.NOOP_INSTRUCTION) continue;
            instructions.add(a.instruction);
        }
        return instructions;
    }

    public static void evaluateExpectations(List<SlimAssertion> assertions, Map<String, Object> results) {
        for (SlimAssertion a : assertions) {
            Object returnValue = results.get(a.getInstruction().getId());
            a.getExpectation().evaluateExpectation(returnValue);
        }
    }
}

