/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.DecisionTable;
import fitnesse.testsystems.slim.tables.DynamicDecisionTable;
import fitnesse.testsystems.slim.tables.ImportTable;
import fitnesse.testsystems.slim.tables.LibraryTable;
import fitnesse.testsystems.slim.tables.OrderedQueryTable;
import fitnesse.testsystems.slim.tables.QueryTable;
import fitnesse.testsystems.slim.tables.ScenarioTable;
import fitnesse.testsystems.slim.tables.ScriptTable;
import fitnesse.testsystems.slim.tables.SlimErrorTable;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SubsetQueryTable;
import fitnesse.testsystems.slim.tables.TableTable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SlimTableFactory {
    private static final Logger LOG = Logger.getLogger(SlimTableFactory.class.getName());
    private static final Map<Class<? extends SlimTable>, Constructor<? extends SlimTable>> CONSTRUCTOR_MAP = new HashMap<Class<? extends SlimTable>, Constructor<? extends SlimTable>>();
    private final Map<String, Class<? extends SlimTable>> tableTypes;
    private final Map<String, String> tableTypeArrays;

    public SlimTableFactory() {
        this.tableTypes = new HashMap<String, Class<? extends SlimTable>>(16);
        this.tableTypeArrays = new HashMap<String, String>();
        this.addTableType("dt:", DecisionTable.class);
        this.addTableType("decision:", DecisionTable.class);
        this.addTableType("ddt:", DynamicDecisionTable.class);
        this.addTableType("dynamic decision:", DynamicDecisionTable.class);
        this.addTableType("ordered query:", OrderedQueryTable.class);
        this.addTableType("subset query:", SubsetQueryTable.class);
        this.addTableType("query:", QueryTable.class);
        this.addTableType("table:", TableTable.class);
        this.addTableType("script", ScriptTable.class);
        this.addTableType("script:", ScriptTable.class);
        this.addTableType("scenario", ScenarioTable.class);
        this.addTableType("import", ImportTable.class);
        this.addTableType("library", LibraryTable.class);
    }

    protected SlimTableFactory(HashMap<String, Class<? extends SlimTable>> tableTypes, HashMap<String, String> tableTypeArrays) {
        this.tableTypes = tableTypes;
        this.tableTypeArrays = tableTypeArrays;
    }

    public void addTableType(String nameOrPrefix, Class<? extends SlimTable> tableClass) {
        if (this.tableTypes.get(nameOrPrefix) != null) {
            throw new IllegalStateException("A table type named '" + nameOrPrefix + "' already exists");
        }
        this.tableTypes.put(nameOrPrefix.toLowerCase(), tableClass);
    }

    public SlimTable makeSlimTable(Table table, String tableId, SlimTestContext slimTestContext) {
        String tableType = this.getFullTableName(table.getCellContents(0, 0));
        if (tableType.equalsIgnoreCase("define table type")) {
            this.parseDefineTableTypeTable(table);
            return null;
        }
        if (tableType.equalsIgnoreCase("comment") || tableType.startsWith("comment:")) {
            return null;
        }
        Class<? extends SlimTable> tableClass = this.getTableType(tableType);
        if (tableClass != null) {
            return this.newTableForType(tableClass, table, tableId, slimTestContext);
        }
        if (!this.hasColon(tableType)) {
            return new DecisionTable(table, tableId, slimTestContext);
        }
        return new SlimErrorTable(table, tableId, slimTestContext);
    }

    private boolean hasColon(String tableType) {
        return tableType.contains(":");
    }

    private Class<? extends SlimTable> getTableType(String tableType) {
        if (this.hasColon(tableType)) {
            tableType = tableType.substring(0, tableType.indexOf(58) + 1);
        }
        return this.tableTypes.get(tableType.toLowerCase());
    }

    private SlimTable newTableForType(Class<? extends SlimTable> tableClass, Table table, String tableId, SlimTestContext slimTestContext) {
        try {
            return SlimTableFactory.createTable(tableClass, table, tableId, slimTestContext);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Can not create new table instance for class " + tableClass, e);
            return new SlimErrorTable(table, tableId, slimTestContext);
        }
    }

    public static <T extends SlimTable> T createTable(Class<T> tableClass, Table table, String tableId, SlimTestContext slimTestContext) throws Exception {
        Constructor<SlimTable> constructor = CONSTRUCTOR_MAP.get(tableClass);
        if (constructor == null) {
            constructor = tableClass.getConstructor(Table.class, String.class, SlimTestContext.class);
            CONSTRUCTOR_MAP.put(tableClass, constructor);
        }
        return (T)constructor.newInstance(table, tableId, slimTestContext);
    }

    private String getFullTableName(String tableName) {
        if (this.hasColon(tableName)) {
            return tableName;
        }
        String disgracedName = SlimTable.Disgracer.disgraceClassName(tableName);
        if (this.tableTypeArrays.containsKey(disgracedName)) {
            return this.tableTypeArrays.get(disgracedName) + ":" + tableName;
        }
        return tableName;
    }

    private SlimTable parseDefineTableTypeTable(Table table) {
        for (int rowIndex = 1; rowIndex < table.getRowCount(); ++rowIndex) {
            this.parseDefineTableTypeRow(table, rowIndex);
        }
        return null;
    }

    private void parseDefineTableTypeRow(Table table, int rowIndex) {
        if (table.getColumnCountInRow(rowIndex) >= 2) {
            String fixtureName = table.getCellContents(0, rowIndex);
            String fixture = SlimTable.Disgracer.disgraceClassName(fixtureName);
            String tableSpecifier = table.getCellContents(1, rowIndex).toLowerCase();
            this.tableTypeArrays.put(fixture, this.makeTableType(tableSpecifier));
        }
    }

    private String makeTableType(String tableSpecifier) {
        String tableType = tableSpecifier.replace(':', ' ');
        if (tableType.startsWith("as")) {
            tableType = tableType.substring(2);
        }
        return tableType.trim();
    }

    public SlimTableFactory copy() {
        return new SlimTableFactory(new HashMap<String, Class<? extends SlimTable>>(this.tableTypes), new HashMap<String, String>(this.tableTypeArrays));
    }
}

