/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.util;

import java.util.Vector;
import org.htmlparser.Attribute;
import org.htmlparser.Node;
import org.htmlparser.Tag;
import org.htmlparser.util.NodeList;

public final class HtmlParserTools {
    private HtmlParserTools() {
    }

    public static Node flatClone(Node node) {
        if (node == null) {
            return null;
        }
        Node newNode = HtmlParserTools.cloneOnlyNode(node, null);
        newNode.setChildren(new NodeList());
        if (newNode instanceof Tag) {
            ((Tag)newNode).setEndTag(null);
        }
        return newNode;
    }

    public static NodeList deepClone(NodeList nodeList) {
        return HtmlParserTools.deepClone(nodeList, null);
    }

    public static <T extends Node> T deepClone(T node) {
        return (T)HtmlParserTools.deepClone(new NodeList(node), null).elementAt(0);
    }

    public static Node endTag(Node node) {
        return node instanceof Tag ? ((Tag)node).getEndTag() : null;
    }

    private static NodeList deepClone(NodeList tree, Node clonedParent) {
        NodeList newNodeList = new NodeList();
        for (int i = 0; i < tree.size(); ++i) {
            Node node = tree.elementAt(i);
            Node newNode = HtmlParserTools.cloneOnlyNode(node, clonedParent);
            newNodeList.add(newNode);
            if (node.getChildren() == null) continue;
            newNode.setChildren(HtmlParserTools.deepClone(node.getChildren(), newNode));
        }
        return newNodeList;
    }

    private static Node cloneOnlyNode(Node node, Node clonedParent) {
        Node newNode;
        try {
            newNode = (Node)node.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Node must be cloneable", e);
        }
        node.setParent(clonedParent);
        if (newNode instanceof Tag) {
            Tag newTag = (Tag)newNode;
            newTag.setAttributesEx(HtmlParserTools.cloneAttributes(((Tag)node).getAttributesEx()));
        }
        return newNode;
    }

    private static Vector cloneAttributes(Vector<Attribute> attributes) {
        Vector<Attribute> newAttributes = new Vector<Attribute>(attributes.size());
        for (Attribute a : attributes) {
            newAttributes.add(new Attribute(a.getName(), a.getAssignment(), a.getValue(), a.getQuote()));
        }
        return newAttributes;
    }
}

