/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.html.HtmlUtil;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.Expression;
import util.Maybe;

public class FormattedExpression {
    public static final Pattern formatParser = Pattern.compile("^[ \\t]*((%[-#+ 0,(]*[0-9.]*([a-zA-Z])[^: \\t]*)[ \\t]*:)?[ \\t]*(.*)$");
    private String input;
    private String format;
    private char conversion = (char)63;
    private String expression;

    public FormattedExpression(String input) {
        this.input = input;
    }

    public Maybe<String> evaluate() {
        this.parseFormat();
        return this.expression.length() > 0 ? this.evaluateAndFormat() : new Maybe<String>("");
    }

    private void parseFormat() {
        Matcher match = formatParser.matcher(this.input);
        if (match.find()) {
            this.format = match.group(2) == null ? null : match.group(2).trim();
            this.conversion = (char)(match.group(3) == null ? 63 : (int)match.group(3).trim().charAt(0));
            this.expression = match.group(4) == null ? "" : match.group(4).trim();
        } else {
            this.format = null;
            this.expression = this.input.trim();
        }
    }

    private Maybe<String> evaluateAndFormat() {
        Maybe<Double> evaluation = new Expression(this.expression).evaluate();
        if (evaluation.isNothing()) {
            return Maybe.nothingBecause("invalid expression: " + this.expression);
        }
        Double result = evaluation.getValue();
        Long iResult = Math.round(result);
        if (this.format == null) {
            return new Maybe<String>(result.equals(iResult.doubleValue()) ? iResult.toString() : result.toString());
        }
        if ("aAdhHoOxX".indexOf(this.conversion) >= 0) {
            return new Maybe<String>(String.format(this.format, iResult));
        }
        if ("bB".indexOf(this.conversion) >= 0) {
            return new Maybe<String>(result == 0.0 ? "false" : "true");
        }
        if ("sScC".indexOf(this.conversion) >= 0) {
            boolean isInt = result.equals(iResult.doubleValue());
            String sString = isInt ? String.format(this.format, iResult.toString()) : String.format(this.format, result.toString());
            return new Maybe<String>(sString.replaceAll(" ", HtmlUtil.NBSP.html()));
        }
        if ("tT".indexOf(this.conversion) >= 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(iResult);
            return new Maybe<String>(String.format(this.format, cal.getTime()));
        }
        if ("eEfgG".indexOf(this.conversion) >= 0) {
            return new Maybe<String>(String.format(this.format, result));
        }
        return Maybe.nothingBecause("invalid format: " + this.format);
    }
}

