/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.CachingPathResolver;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.ParsingPathResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventState {
    private static final Logger log = LoggerFactory.getLogger(EventState.class);
    private static CachingPathResolver cachingPathResolver;
    static final String SRC_ABS_PATH = "srcAbsPath";
    static final String DEST_ABS_PATH = "destAbsPath";
    static final String SRC_CHILD_REL_PATH = "srcChildRelPath";
    static final String DEST_CHILD_REL_PATH = "destChildRelPath";
    private final int type;
    private final NodeId parentId;
    private final Path parentPath;
    private final NodeId childId;
    private final Path childRelPath;
    private final Name nodeType;
    private final Set<Name> mixins;
    private Set<NodeType> allTypes;
    private final Session session;
    private String stringValue;
    private int hashCode;
    private final boolean external;
    private Map<String, InternalValue> info = Collections.emptyMap();
    private boolean shareableNode;

    private EventState(int type, NodeId parentId, Path parentPath, NodeId childId, Path childPath, Name nodeType, Set<Name> mixins, Session session, boolean external) {
        int mask = 28;
        if ((type & mask) > 0) {
            if (childId != null) {
                throw new IllegalArgumentException("childId only allowed for Node events.");
            }
        } else if (childId == null && type != 64) {
            throw new IllegalArgumentException("childId must not be null for Node events.");
        }
        this.type = type;
        this.parentId = parentId;
        this.parentPath = parentPath;
        this.childId = childId;
        this.childRelPath = childPath;
        this.nodeType = nodeType;
        this.mixins = mixins;
        this.session = session;
        this.external = external;
    }

    public static EventState childNodeAdded(NodeId parentId, Path parentPath, NodeId childId, Path childPath, Name nodeType, Set<Name> mixins, Session session) {
        return EventState.childNodeAdded(parentId, parentPath, childId, childPath, nodeType, mixins, session, false);
    }

    public static EventState childNodeAdded(NodeId parentId, Path parentPath, NodeId childId, Path childPath, Name nodeType, Set<Name> mixins, Session session, boolean external) {
        return new EventState(1, parentId, parentPath, childId, childPath, nodeType, mixins, session, external);
    }

    public static EventState childNodeRemoved(NodeId parentId, Path parentPath, NodeId childId, Path childPath, Name nodeType, Set<Name> mixins, Session session) {
        return EventState.childNodeRemoved(parentId, parentPath, childId, childPath, nodeType, mixins, session, false);
    }

    public static EventState childNodeRemoved(NodeId parentId, Path parentPath, NodeId childId, Path childPath, Name nodeType, Set<Name> mixins, Session session, boolean external) {
        return new EventState(2, parentId, parentPath, childId, childPath, nodeType, mixins, session, external);
    }

    public static EventState nodeMoved(NodeId parentId, Path parentPath, NodeId childId, Path childPath, Name nodeType, Set<Name> mixins, Session session, boolean external) {
        return new EventState(32, parentId, parentPath, childId, childPath, nodeType, mixins, session, external);
    }

    public static EventState nodeMovedWithInfo(NodeId parentId, Path destPath, NodeId childId, Path srcPath, Name nodeType, Set<Name> mixins, Session session, boolean external) throws ItemStateException {
        try {
            EventState es = EventState.nodeMoved(parentId, destPath.getAncestor(1), childId, destPath, nodeType, mixins, session, external);
            HashMap<String, InternalValue> info = new HashMap<String, InternalValue>();
            info.put(SRC_ABS_PATH, InternalValue.create(srcPath));
            info.put(DEST_ABS_PATH, InternalValue.create(destPath));
            es.setInfo(info);
            return es;
        }
        catch (RepositoryException e) {
            String msg = "Unable to resolve parent for path: " + destPath;
            log.error(msg);
            throw new ItemStateException(msg, e);
        }
    }

    public static EventState nodeReordered(NodeId parentId, Path parentPath, NodeId childId, Path destChildPath, Path srcChildPath, Path beforeChildPath, Name nodeType, Set<Name> mixins, Session session, boolean external) {
        EventState es = EventState.nodeMoved(parentId, parentPath, childId, destChildPath, nodeType, mixins, session, external);
        HashMap<String, InternalValue> info = new HashMap<String, InternalValue>();
        info.put(SRC_CHILD_REL_PATH, EventState.createValue(srcChildPath));
        InternalValue value = null;
        if (beforeChildPath != null) {
            value = EventState.createValue(beforeChildPath);
        }
        info.put(DEST_CHILD_REL_PATH, value);
        es.setInfo(info);
        return es;
    }

    public static EventState propertyAdded(NodeId parentId, Path parentPath, Path childPath, Name nodeType, Set<Name> mixins, Session session) {
        return EventState.propertyAdded(parentId, parentPath, childPath, nodeType, mixins, session, false);
    }

    public static EventState propertyAdded(NodeId parentId, Path parentPath, Path childPath, Name nodeType, Set<Name> mixins, Session session, boolean external) {
        return new EventState(4, parentId, parentPath, null, childPath, nodeType, mixins, session, external);
    }

    public static EventState propertyRemoved(NodeId parentId, Path parentPath, Path childPath, Name nodeType, Set<Name> mixins, Session session) {
        return EventState.propertyRemoved(parentId, parentPath, childPath, nodeType, mixins, session, false);
    }

    public static EventState propertyRemoved(NodeId parentId, Path parentPath, Path childPath, Name nodeType, Set<Name> mixins, Session session, boolean external) {
        return new EventState(8, parentId, parentPath, null, childPath, nodeType, mixins, session, external);
    }

    public static EventState propertyChanged(NodeId parentId, Path parentPath, Path childPath, Name nodeType, Set<Name> mixins, Session session) {
        return EventState.propertyChanged(parentId, parentPath, childPath, nodeType, mixins, session, false);
    }

    public static EventState propertyChanged(NodeId parentId, Path parentPath, Path childPath, Name nodeType, Set<Name> mixins, Session session, boolean external) {
        return new EventState(16, parentId, parentPath, null, childPath, nodeType, mixins, session, external);
    }

    public static EventState persist(Session session, boolean external) {
        return new EventState(64, null, null, null, null, null, null, session, external);
    }

    public int getType() {
        return this.type;
    }

    public NodeId getParentId() {
        return this.parentId;
    }

    public Path getParentPath() {
        return this.parentPath;
    }

    public NodeId getChildId() {
        return this.childId;
    }

    public Path getChildRelPath() {
        return this.childRelPath;
    }

    public Name getNodeType() {
        return this.nodeType;
    }

    public Set<Name> getMixinNames() {
        return this.mixins;
    }

    public Set<NodeType> getNodeTypes(NodeTypeManagerImpl ntMgr) {
        if (this.allTypes == null) {
            HashSet<NodeTypeImpl> tmp = new HashSet<NodeTypeImpl>();
            try {
                tmp.add(ntMgr.getNodeType(this.nodeType));
            }
            catch (NoSuchNodeTypeException e) {
                log.warn("Unknown node type: " + this.nodeType);
            }
            for (Name mixinName : this.mixins) {
                try {
                    tmp.add(ntMgr.getNodeType(mixinName));
                }
                catch (NoSuchNodeTypeException e) {
                    log.warn("Unknown node type: " + mixinName);
                }
            }
            this.allTypes = Collections.unmodifiableSet(tmp);
        }
        return this.allTypes;
    }

    public String getUserId() {
        return this.session.getUserID();
    }

    Session getSession() {
        return this.session;
    }

    ItemId getTargetId() {
        if (this.type == 64) {
            return null;
        }
        if (this.childId == null) {
            return new PropertyId(this.parentId, this.childRelPath.getName());
        }
        return this.childId;
    }

    boolean isExternal() {
        return this.external;
    }

    public Map<String, InternalValue> getInfo() {
        return this.info;
    }

    public void setInfo(Map<String, InternalValue> info) {
        this.info = Collections.unmodifiableMap(new HashMap<String, InternalValue>(info));
    }

    boolean isShareableNode() {
        return this.shareableNode;
    }

    void setShareableNode(boolean shareableNode) {
        this.shareableNode = shareableNode;
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("EventState: ").append(EventState.valueOf(this.type));
            sb.append(", Parent: ").append(this.parentId);
            sb.append(", Child: ").append(this.childRelPath);
            sb.append(", UserId: ").append(this.session.getUserID());
            sb.append(", Info: ").append(this.info);
            this.stringValue = sb.toString();
        }
        return this.stringValue;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            h = 37;
            h = 37 * h + this.type;
            h = 37 * h + (this.parentId != null ? this.parentId.hashCode() : 0);
            h = 37 * h + (this.childRelPath != null ? this.childRelPath.hashCode() : 0);
            h = 37 * h + this.session.hashCode();
            this.hashCode = h = 37 * h + this.info.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof EventState) {
            EventState other = (EventState)obj;
            return this.type == other.type && this.parentId.equals(other.parentId) && this.childRelPath.equals(other.childRelPath) && this.session.equals(other.session) && this.info.equals(other.info);
        }
        return false;
    }

    public static String valueOf(int eventType) {
        if (eventType == 1) {
            return "NodeAdded";
        }
        if (eventType == 32) {
            return "NodeMoved";
        }
        if (eventType == 2) {
            return "NodeRemoved";
        }
        if (eventType == 4) {
            return "PropertyAdded";
        }
        if (eventType == 16) {
            return "PropertyChanged";
        }
        if (eventType == 8) {
            return "PropertyRemoved";
        }
        if (eventType == 64) {
            return "Persist";
        }
        return "UnknownEventType";
    }

    private static InternalValue createValue(Path path) {
        return InternalValue.create(path);
    }

    public static String getCommonPath(List<EventState> events, SessionImpl session) {
        String common = null;
        try {
            for (int i = 0; i < events.size(); ++i) {
                int idx;
                EventState state = events.get(i);
                Path parentPath = state.getParentPath();
                String s = session == null ? EventState.getJCRPath(parentPath) : session.getJCRPath(parentPath);
                if (common == null) {
                    common = s;
                    continue;
                }
                if (common.equals(s)) continue;
                if (s.length() < common.length()) {
                    String temp = common;
                    common = s;
                    s = temp;
                }
                while (!s.startsWith(common) && (idx = s.lastIndexOf(47)) >= 0) {
                    common = s.substring(0, idx + 1);
                }
            }
        }
        catch (NamespaceException e) {
            log.debug("Problem in retrieving JCR path", (Throwable)e);
        }
        return common;
    }

    private static String getJCRPath(Path path) {
        String jcrPath;
        EventState.setupCachingPathResolver();
        try {
            jcrPath = cachingPathResolver.getJCRPath(path);
        }
        catch (NamespaceException e) {
            jcrPath = "";
            log.debug("Problem in retrieving JCR path", (Throwable)e);
        }
        return jcrPath;
    }

    private static void setupCachingPathResolver() {
        if (cachingPathResolver != null) {
            return;
        }
        ParsingPathResolver pathResolver = new ParsingPathResolver(PathFactoryImpl.getInstance(), new NameResolver(){

            public Name getQName(String name) throws IllegalNameException, NamespaceException {
                return null;
            }

            public String getJCRName(Name name) throws NamespaceException {
                return name.getLocalName();
            }
        });
        cachingPathResolver = new CachingPathResolver((PathResolver)pathResolver);
    }
}

