/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.fitnesse;

import com.xebialabs.xltest.fitnesse.Feedback;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FeedbackEventSender
implements Feedback {
    private static final Logger LOG = Logger.getLogger(FeedbackEventSender.class.getName());
    private final URL feedbackUrl;

    public FeedbackEventSender(URL url) {
        this.feedbackUrl = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void found(Object summary) {
        HttpURLConnection connection = null;
        try {
            byte[] data = summary.toString().getBytes("UTF-8");
            connection = (HttpURLConnection)this.feedbackUrl.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects(false);
            connection.setUseCaches(false);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            connection.setRequestProperty("Content-Length", Integer.toString(data.length));
            OutputStream out = connection.getOutputStream();
            out.write(data);
            out.flush();
            out.close();
            int responseCode = connection.getResponseCode();
            LOG.info("Sent event, response code: " + responseCode + ", " + summary);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Could not deliver page information", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

