/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest;

import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.search.spell.TermFreqIterator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefArray;
import org.apache.lucene.util.Counter;

public class BufferingTermFreqIteratorWrapper
implements TermFreqIterator {
    protected BytesRefArray entries = new BytesRefArray(Counter.newCounter());
    protected int curPos = -1;
    protected long[] freqs = new long[1];
    private final BytesRef spare = new BytesRef();
    private final Comparator<BytesRef> comp;

    public BufferingTermFreqIteratorWrapper(TermFreqIterator source) throws IOException {
        BytesRef spare;
        this.comp = source.getComparator();
        int freqIndex = 0;
        while ((spare = source.next()) != null) {
            this.entries.append(spare);
            if (freqIndex >= this.freqs.length) {
                this.freqs = ArrayUtil.grow((long[])this.freqs, (int)(this.freqs.length + 1));
            }
            this.freqs[freqIndex++] = source.weight();
        }
    }

    @Override
    public long weight() {
        return this.freqs[this.curPos];
    }

    public BytesRef next() throws IOException {
        if (++this.curPos < this.entries.size()) {
            this.entries.get(this.spare, this.curPos);
            return this.spare;
        }
        return null;
    }

    public Comparator<BytesRef> getComparator() {
        return this.comp;
    }
}

