/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete.index;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.delete.index.IndexDeleteRequest;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.uid.Versions;

public class ShardDeleteRequest
extends ShardReplicationOperationRequest<ShardDeleteRequest> {
    private int shardId;
    private String type;
    private String id;
    private boolean refresh = false;
    private long version;

    ShardDeleteRequest(IndexDeleteRequest request, int shardId) {
        super(request);
        this.index = request.index();
        this.shardId = shardId;
        this.type = request.type();
        this.id = request.id();
        this.replicationType(request.replicationType());
        this.consistencyLevel(request.consistencyLevel());
        this.timeout = request.timeout();
        this.refresh = request.refresh();
        this.version = request.version();
    }

    ShardDeleteRequest() {
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.type == null) {
            ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.id == null) {
            ValidateActions.addValidationError("id is missing", validationException);
        }
        return validationException;
    }

    public int shardId() {
        return this.shardId;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public void version(long version) {
        this.version = version;
    }

    public long version() {
        return this.version;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardId = in.readVInt();
        this.type = in.readString();
        this.id = in.readString();
        this.refresh = in.readBoolean();
        this.version = Versions.readVersion(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.shardId);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeBoolean(this.refresh);
        Versions.writeVersion(this.version, out);
    }
}

