/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.HashMap;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.cluster.node.stats.TransportNodesStatsAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.admin.indices.stats.TransportIndicesStatsAction;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.monitor.fs.FsStats;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;

public final class InternalClusterInfoService
extends AbstractComponent
implements ClusterInfoService,
LocalNodeMasterListener,
ClusterStateListener {
    public static final String INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL = "cluster.info.update.interval";
    private volatile TimeValue updateFrequency;
    private volatile ImmutableMap<String, DiskUsage> usages = ImmutableMap.of();
    private volatile ImmutableMap<String, Long> shardSizes = ImmutableMap.of();
    private volatile boolean isMaster = false;
    private volatile boolean enabled;
    private final TransportNodesStatsAction transportNodesStatsAction;
    private final TransportIndicesStatsAction transportIndicesStatsAction;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;

    @Inject
    public InternalClusterInfoService(Settings settings, NodeSettingsService nodeSettingsService, TransportNodesStatsAction transportNodesStatsAction, TransportIndicesStatsAction transportIndicesStatsAction, ClusterService clusterService, ThreadPool threadPool) {
        super(settings);
        this.transportNodesStatsAction = transportNodesStatsAction;
        this.transportIndicesStatsAction = transportIndicesStatsAction;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.updateFrequency = settings.getAsTime(INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL, TimeValue.timeValueSeconds(30L));
        this.enabled = settings.getAsBoolean("cluster.routing.allocation.disk.threshold_enabled", (Boolean)false);
        nodeSettingsService.addListener(new ApplySettings());
        this.clusterService.add(this);
        this.clusterService.add(this);
    }

    @Override
    public void onMaster() {
        block4: {
            this.isMaster = true;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("I have been elected master, scheduling a ClusterInfoUpdateJob", new Object[0]);
            }
            try {
                this.threadPool.schedule(this.updateFrequency, this.executorName(), new SubmitReschedulingClusterInfoUpdatedJob());
                if (this.clusterService.state().getNodes().getDataNodes().size() > 1) {
                    this.threadPool.executor(this.executorName()).execute(new ClusterInfoUpdateJob(false));
                }
            }
            catch (EsRejectedExecutionException ex) {
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.debug("Couldn't schedule cluster info update task - node might be shutting down", ex, new Object[0]);
            }
        }
    }

    @Override
    public void offMaster() {
        this.isMaster = false;
    }

    @Override
    public String executorName() {
        return "management";
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!this.enabled) {
            return;
        }
        boolean dataNodeAdded = false;
        for (DiscoveryNode addedNode : event.nodesDelta().addedNodes()) {
            if (!addedNode.dataNode()) continue;
            dataNodeAdded = true;
            break;
        }
        if (this.isMaster && dataNodeAdded && this.clusterService.state().getNodes().getDataNodes().size() > 1) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("data node was added, retrieving new cluster info", new Object[0]);
            }
            this.threadPool.executor(this.executorName()).execute(new ClusterInfoUpdateJob(false));
        }
        if (this.isMaster && event.nodesRemoved()) {
            for (DiscoveryNode removedNode : event.nodesDelta().removedNodes()) {
                if (!removedNode.dataNode()) continue;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Removing node from cluster info: {}", removedNode.getId());
                }
                HashMap<String, DiskUsage> newUsages = new HashMap<String, DiskUsage>(this.usages);
                newUsages.remove(removedNode.getId());
                this.usages = ImmutableMap.copyOf(newUsages);
            }
        }
    }

    @Override
    public ClusterInfo getClusterInfo() {
        return new ClusterInfo(this.usages, this.shardSizes);
    }

    public static String shardIdentifierFromRouting(ShardRouting shardRouting) {
        return shardRouting.shardId().toString() + "[" + (shardRouting.primary() ? "p" : "r") + "]";
    }

    public class ClusterInfoUpdateJob
    implements Runnable {
        private final boolean reschedule;

        public ClusterInfoUpdateJob(boolean reschedule) {
            this.reschedule = reschedule;
        }

        @Override
        public void run() {
            if (InternalClusterInfoService.this.logger.isTraceEnabled()) {
                InternalClusterInfoService.this.logger.trace("Performing ClusterInfoUpdateJob", new Object[0]);
            }
            if (InternalClusterInfoService.this.isMaster && this.reschedule) {
                if (InternalClusterInfoService.this.logger.isTraceEnabled()) {
                    InternalClusterInfoService.this.logger.trace("Scheduling next run for updating cluster info in: {}", InternalClusterInfoService.this.updateFrequency.toString());
                }
                try {
                    InternalClusterInfoService.this.threadPool.schedule(InternalClusterInfoService.this.updateFrequency, InternalClusterInfoService.this.executorName(), new SubmitReschedulingClusterInfoUpdatedJob());
                }
                catch (EsRejectedExecutionException ex) {
                    InternalClusterInfoService.this.logger.debug("Reschedule cluster info service was rejected", ex, new Object[0]);
                }
            }
            if (!InternalClusterInfoService.this.enabled) {
                if (InternalClusterInfoService.this.logger.isTraceEnabled()) {
                    InternalClusterInfoService.this.logger.trace("Skipping ClusterInfoUpdatedJob since it is disabled", new Object[0]);
                }
                return;
            }
            NodesStatsRequest nodesStatsRequest = new NodesStatsRequest("data:true");
            nodesStatsRequest.clear();
            nodesStatsRequest.fs(true);
            nodesStatsRequest.timeout(TimeValue.timeValueSeconds(15L));
            InternalClusterInfoService.this.transportNodesStatsAction.execute(nodesStatsRequest, new ActionListener<NodesStatsResponse>(){

                @Override
                public void onResponse(NodesStatsResponse nodeStatses) {
                    HashMap<String, DiskUsage> newUsages = new HashMap<String, DiskUsage>();
                    for (NodeStats nodeStats : (NodeStats[])nodeStatses.getNodes()) {
                        if (nodeStats.getFs() == null) {
                            InternalClusterInfoService.this.logger.warn("Unable to retrieve node FS stats for {}", nodeStats.getNode().name());
                            continue;
                        }
                        long available = 0L;
                        long total = 0L;
                        for (FsStats.Info info : nodeStats.getFs()) {
                            available += info.getAvailable().bytes();
                            total += info.getTotal().bytes();
                        }
                        String nodeId = nodeStats.getNode().id();
                        if (InternalClusterInfoService.this.logger.isTraceEnabled()) {
                            InternalClusterInfoService.this.logger.trace("node: [{}], total disk: {}, available disk: {}", nodeId, total, available);
                        }
                        newUsages.put(nodeId, new DiskUsage(nodeId, total, available));
                    }
                    InternalClusterInfoService.this.usages = ImmutableMap.copyOf(newUsages);
                }

                @Override
                public void onFailure(Throwable e) {
                    if (e instanceof ClusterBlockException) {
                        if (InternalClusterInfoService.this.logger.isTraceEnabled()) {
                            InternalClusterInfoService.this.logger.trace("Failed to execute NodeStatsAction for ClusterInfoUpdateJob", e, new Object[0]);
                        }
                    } else {
                        InternalClusterInfoService.this.logger.warn("Failed to execute NodeStatsAction for ClusterInfoUpdateJob", e, new Object[0]);
                    }
                }
            });
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.clear();
            indicesStatsRequest.store(true);
            InternalClusterInfoService.this.transportIndicesStatsAction.execute(indicesStatsRequest, new ActionListener<IndicesStatsResponse>(){

                @Override
                public void onResponse(IndicesStatsResponse indicesStatsResponse) {
                    ShardStats[] stats = indicesStatsResponse.getShards();
                    HashMap<String, Long> newShardSizes = new HashMap<String, Long>();
                    for (ShardStats s : stats) {
                        long size = s.getStats().getStore().sizeInBytes();
                        String sid = InternalClusterInfoService.shardIdentifierFromRouting(s.getShardRouting());
                        if (InternalClusterInfoService.this.logger.isTraceEnabled()) {
                            InternalClusterInfoService.this.logger.trace("shard: {} size: {}", sid, size);
                        }
                        newShardSizes.put(sid, size);
                    }
                    InternalClusterInfoService.this.shardSizes = ImmutableMap.copyOf(newShardSizes);
                }

                @Override
                public void onFailure(Throwable e) {
                    if (e instanceof ClusterBlockException) {
                        if (InternalClusterInfoService.this.logger.isTraceEnabled()) {
                            InternalClusterInfoService.this.logger.trace("Failed to execute IndicesStatsAction for ClusterInfoUpdateJob", e, new Object[0]);
                        }
                    } else {
                        InternalClusterInfoService.this.logger.warn("Failed to execute IndicesStatsAction for ClusterInfoUpdateJob", e, new Object[0]);
                    }
                }
            });
            if (InternalClusterInfoService.this.logger.isTraceEnabled()) {
                InternalClusterInfoService.this.logger.trace("Finished ClusterInfoUpdateJob", new Object[0]);
            }
        }
    }

    public class SubmitReschedulingClusterInfoUpdatedJob
    implements Runnable {
        @Override
        public void run() {
            block3: {
                if (InternalClusterInfoService.this.logger.isTraceEnabled()) {
                    InternalClusterInfoService.this.logger.trace("Submitting new rescheduling cluster info update job", new Object[0]);
                }
                try {
                    InternalClusterInfoService.this.threadPool.executor(InternalClusterInfoService.this.executorName()).execute(new ClusterInfoUpdateJob(true));
                }
                catch (EsRejectedExecutionException ex) {
                    if (!InternalClusterInfoService.this.logger.isDebugEnabled()) break block3;
                    InternalClusterInfoService.this.logger.debug("Couldn't re-schedule cluster info update task - node might be shutting down", ex, new Object[0]);
                }
            }
        }
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            TimeValue newUpdateFrequency = settings.getAsTime(InternalClusterInfoService.INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL, null);
            Boolean newEnabled = settings.getAsBoolean("cluster.routing.allocation.disk.threshold_enabled", null);
            if (newUpdateFrequency != null) {
                if (newUpdateFrequency.getMillis() < TimeValue.timeValueSeconds(10L).getMillis()) {
                    InternalClusterInfoService.this.logger.warn("[{}] set too low [{}] (< 10s)", InternalClusterInfoService.INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL, newUpdateFrequency);
                    throw new IllegalStateException("Unable to set cluster.info.update.interval less than 10 seconds");
                }
                InternalClusterInfoService.this.logger.info("updating [{}] from [{}] to [{}]", InternalClusterInfoService.INTERNAL_CLUSTER_INFO_UPDATE_INTERVAL, InternalClusterInfoService.this.updateFrequency, newUpdateFrequency);
                InternalClusterInfoService.this.updateFrequency = newUpdateFrequency;
            }
            if (newEnabled != null) {
                InternalClusterInfoService.this.enabled = newEnabled;
            }
        }
    }
}

