/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.Locale;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class ClusterRebalanceAllocationDecider
extends AllocationDecider {
    public static final String NAME = "cluster_rebalance";
    private final ClusterRebalanceType type;

    @Inject
    public ClusterRebalanceAllocationDecider(Settings settings) {
        super(settings);
        String allowRebalance = settings.get("cluster.routing.allocation.allow_rebalance", "indices_all_active");
        if ("always".equalsIgnoreCase(allowRebalance)) {
            this.type = ClusterRebalanceType.ALWAYS;
        } else if ("indices_primaries_active".equalsIgnoreCase(allowRebalance) || "indicesPrimariesActive".equalsIgnoreCase(allowRebalance)) {
            this.type = ClusterRebalanceType.INDICES_PRIMARIES_ACTIVE;
        } else if ("indices_all_active".equalsIgnoreCase(allowRebalance) || "indicesAllActive".equalsIgnoreCase(allowRebalance)) {
            this.type = ClusterRebalanceType.INDICES_ALL_ACTIVE;
        } else {
            this.logger.warn("[cluster.routing.allocation.allow_rebalance] has a wrong value {}, defaulting to 'indices_all_active'", allowRebalance);
            this.type = ClusterRebalanceType.INDICES_ALL_ACTIVE;
        }
        this.logger.debug("using [cluster.routing.allocation.allow_rebalance] with [{}]", this.type.toString().toLowerCase(Locale.ROOT));
    }

    @Override
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        if (this.type == ClusterRebalanceType.INDICES_PRIMARIES_ACTIVE) {
            if (allocation.routingNodes().hasUnassignedPrimaries()) {
                return allocation.decision(Decision.NO, NAME, "cluster has unassigned primary shards", new Object[0]);
            }
            if (allocation.routingNodes().hasInactivePrimaries()) {
                return allocation.decision(Decision.NO, NAME, "cluster has inactive primary shards", new Object[0]);
            }
            return allocation.decision(Decision.YES, NAME, "all primary shards are active", new Object[0]);
        }
        if (this.type == ClusterRebalanceType.INDICES_ALL_ACTIVE) {
            if (allocation.routingNodes().hasUnassignedShards()) {
                return allocation.decision(Decision.NO, NAME, "cluster has unassigned shards", new Object[0]);
            }
            if (allocation.routingNodes().hasInactiveShards()) {
                return allocation.decision(Decision.NO, NAME, "cluster has inactive shards", new Object[0]);
            }
        }
        return allocation.decision(Decision.YES, NAME, "all shards are active", new Object[0]);
    }

    public static enum ClusterRebalanceType {
        ALWAYS,
        INDICES_PRIMARIES_ACTIVE,
        INDICES_ALL_ACTIVE;

    }
}

