/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.hppc;

import java.util.Arrays;
import org.elasticsearch.common.hppc.FloatCollection;
import org.elasticsearch.common.hppc.FloatLookupContainer;
import org.elasticsearch.common.hppc.cursors.FloatCursor;
import org.elasticsearch.common.hppc.predicates.FloatPredicate;

abstract class AbstractFloatCollection
implements FloatCollection {
    AbstractFloatCollection() {
    }

    @Override
    public int removeAll(FloatLookupContainer c) {
        final FloatLookupContainer c2 = c;
        return this.removeAll(new FloatPredicate(){

            @Override
            public boolean apply(float k) {
                return c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(FloatLookupContainer c) {
        final FloatLookupContainer c2 = c;
        return this.removeAll(new FloatPredicate(){

            @Override
            public boolean apply(float k) {
                return !c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final FloatPredicate predicate) {
        return this.removeAll(new FloatPredicate(){

            @Override
            public boolean apply(float value) {
                return !predicate.apply(value);
            }
        });
    }

    @Override
    public float[] toArray() {
        int size = this.size();
        float[] array = new float[size];
        int i = 0;
        for (FloatCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

