/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;

public class RandomScoreFunction
extends ScoreFunction {
    private final PRNG prng;

    public RandomScoreFunction(long seed) {
        super(CombineFunction.MULT);
        this.prng = new PRNG(seed);
    }

    @Override
    public void setNextReader(AtomicReaderContext context) {
    }

    @Override
    public double score(int docId, float subQueryScore) {
        return this.prng.nextFloat();
    }

    @Override
    public Explanation explainScore(int docId, Explanation subQueryExpl) {
        Explanation exp = new Explanation();
        exp.setDescription("random score function (seed: " + this.prng.originalSeed + ")");
        exp.addDetail(subQueryExpl);
        return exp;
    }

    static class PRNG {
        private static final long multiplier = 25214903917L;
        private static final long addend = 11L;
        private static final long mask = 0xFFFFFFFFFFFFL;
        final long originalSeed;
        long seed;

        PRNG(long seed) {
            this.originalSeed = seed;
            this.seed = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        }

        public float nextFloat() {
            this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            return (float)this.seed / 1.6777216E7f;
        }
    }
}

