/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.ping;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;

public interface ZenPing
extends LifecycleComponent<ZenPing> {
    public void setNodesProvider(DiscoveryNodesProvider var1);

    public void ping(PingListener var1, TimeValue var2) throws ElasticsearchException;

    public static class PingResponse
    implements Streamable {
        public static final PingResponse[] EMPTY = new PingResponse[0];
        private ClusterName clusterName;
        private DiscoveryNode target;
        private DiscoveryNode master;

        private PingResponse() {
        }

        public PingResponse(DiscoveryNode target, DiscoveryNode master, ClusterName clusterName) {
            this.target = target;
            this.master = master;
            this.clusterName = clusterName;
        }

        public ClusterName clusterName() {
            return this.clusterName;
        }

        public DiscoveryNode target() {
            return this.target;
        }

        public DiscoveryNode master() {
            return this.master;
        }

        public static PingResponse readPingResponse(StreamInput in) throws IOException {
            PingResponse response = new PingResponse();
            response.readFrom(in);
            return response;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.clusterName = ClusterName.readClusterName(in);
            this.target = DiscoveryNode.readNode(in);
            if (in.readBoolean()) {
                this.master = DiscoveryNode.readNode(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.clusterName.writeTo(out);
            this.target.writeTo(out);
            if (this.master == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.master.writeTo(out);
            }
        }

        public String toString() {
            return "ping_response{target [" + this.target + "], master [" + this.master + "], cluster_name[" + this.clusterName.value() + "]}";
        }
    }

    public static interface PingListener {
        public void onPing(PingResponse[] var1);
    }
}

